/* ARPTR2FN.CPP: Defining and Using Pointers to Functions

		This program defines a five element array of pointers to
		functions that take no arguments and return nothing.  It then
		initilizes the first two elements of the array with pointers
		to actual functions and executes these functions via the array
		pointers.
*/

#include <stdio.h>		// for printf()

// Define 'p' is an array of 5 pointers to functions which
// take no parameters and return nothing.
void (*p[5])(void);

/*-------------------------------------------------------------------
	function1 - The first demo function
*/

void function1(void) {
	printf("Hello, in function function1\n");
}

/*-------------------------------------------------------------------
	function2 - The second demo function
*/

void function2(void) {
	printf("Hello, in function function2\n");
}

//*******************************************************************
int main()
{
	// Pointer at array index 0 points at function function1.
	p[0]=function1;

	// Pointer at array index 1 points at function function2.
	p[1]=function2;

	// Call function2 directly and then via the array
	function2();
	p[1]();

	// Call function1 directly and then via the array
	function1();
	p[0]();

	return 0;
} // end of main()
