/* CHPASS.C: Child Process

    Must be compiled in a memory model which uses far pointers by
    default, i.e., compact, large or huge.
*/

#include <process.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#pragma warn -par   // we know argc is never used!
//*******************************************************************
int main(int argc, char **argv)
{
	char *segment, *offset, *address;
	unsigned seg, off, length;

	// extract the segment value from the string
	segment = (char*) calloc(10,sizeof(unsigned));
	length = (unsigned)(argv[1][0] - 48);
	strcpy( segment, &argv[1][1]);
	segment[length] = NULL;

	// extract the offset value from the string
	offset = (char*) calloc(10,sizeof(unsigned));
	strcpy(offset,&argv[1][length+1]);

	// convert from ascii to integer
	seg = atoi(segment);
	off = atoi(offset);

	// make pointer to parent data, and modify string
	address = (char*) MK_FP(seg,off);
	strcpy(address,"Child    modified");

	return 0;
} // end of main()
