/* DOSTIME.C: A Time Conversion Structure

		The following code demonstrates a interesting technique for
		converting the DOS date/time stamp as provided by an 'ffblk'
		structure to ASCIIZ. This code compiles with ANSI C or C++
		compiler.  Read the comments carefully since they provide
		insight into the method used.
*/

#include <dir.h>			// for ffblk and findfirst()
#include <stdio.h>		// for sprintf()

struct ffblk xffblk;

#pragma warn -par   // we know that argc is nevre used!
//*******************************************************************
int main(int argc, char **argv) {
	char times[9],
			 dates[9];

  /* Create a 'fdate' structure of bit fields and a 'd' pointer
		 instance of this structure that maps the bit fields over the
     date member of the 'xffblk' instance of the 'ffblk' structure
     provided by DOS.H. Kind'a like a post facto union. This permits
		 us to refer to the day, month and year bits of the DOS FCB
     by name. */
	typedef struct fdate {
    unsigned day   :5;		// 5 bits to represent the day
    unsigned month :4;		// 4 bits for the month
    unsigned year  :7;		// 7 bits for the years since 1980
  } fdate;

  // Make an instance that overlays 'xxfblk.ff_fdate'
	fdate *d = (fdate*) &(xffblk.ff_fdate);

  /* In a C++ program this could be simplified into:
	 struct fdate {
		 unsigned day   :5;
	   unsigned month :4;
		 unsigned year  :7;
	 } *d = (fdate*) &(xffblk.ff_date);
     by observing that structures are always types and the structures
     tag (i.e., 'fdate') is available as soon as it is declared.
  */

  // Ditto for the seconds, minutes and hour bits of the time member.
  typedef struct ftime {
		unsigned sec   :5;          // 5 bits for the seconds
    unsigned min   :6;		// 6 bits for the minutes
    unsigned hour  :5;		// 5 bits for the hours
	} ftime;

	// make an instance that overlays 'xxfblk.ff_ftime'
	ftime *t = (ftime*) &(xffblk.ff_ftime);

  /* Load 'xffblk' with info about this program (executing program is
     always contained in first argv array ASCIIZ string). */
	findfirst(*argv, &xffblk, 0xFF);

  // Format time and date using named bit fields & print.
	sprintf(times, "%02u:%02u:%02u", t->hour, t->min, t->sec);
  sprintf(dates, "%02u-%02u-%02u", d->month, d->day, d->year+80);
  printf("%s created:  %s %s\n", *argv, dates, times);
	return 0;
} // end of main()
