/* F.CPP: Pointers and Members Functions

	The following code demonstrates defining a pointer to a member
	function, and defining a member of a class to be a pointer to a
	member function of another class.
*/

#include <iostream.h>

class A {
	public:
		void foo(void) {
			cout << "\nin A::foo";
    }
};

class B {
  public:
    void(A::*ptr)(void); //pointer to member function of class A
};                       //that takes void parameters and returns
                         //void, defined in class B

//*******************************************************************
int main()
{
  B xx;
  A yy;

  void(A::*ptr2)(void); // ptr to member function of class A
                        // defined locally
  ptr2=&A::foo;         // assign addr of member function to variable

  (yy.*ptr2)();         // call member function using local definition

  xx.ptr=&A::foo;       // assign address of member function to member
                        // of class B, which is a ptr to a member
                        // function of class A.

	(yy.*(xx.ptr))();     // call member function using variable in class B
	return 0;
} // end of main()
