/* GPRINT.C: Prints a graphics screen on an Epson compatible printer
*/

#include <graphics.h>
#include <stdio.h>
#include <bios.h>					// for biosprint()
#include <io.h>

#define ESC  '\x1B'
#define LPT1 0
#define LPT2 1

#define prn_putc(x) biosprint(0,(x),LPT1)

/*-------------------------------------------------------------------
	bitImage - Sets Epson printer to bit image mode. 'Nbytes" is
						 the number of bytes to PRINT.
*/

static void bitImage(int Nbytes) {
	register int n1, n2;

	//  Nbytes = (256 * n2) + n1
	n2 = Nbytes >> 8;
	n1 = Nbytes - (n2 << 8);

	// 8-pin, Horizontal density = 80 dots/in.
	prn_putc(ESC);
	prn_putc('*');
	prn_putc(4);
	prn_putc(n1);
	prn_putc(n2);
} // end of bitImage()

/*-------------------------------------------------------------------
	getScrBits - Get pixels from the screen and convert them to the
							 printer's pin order.
*/

static unsigned char getScrBits(int x, int y) {
	unsigned char firePins;

	firePins  = (getpixel(x, y++)==0)? 0: 0x80;
	firePins |= (getpixel(x, y++)==0)? 0: 0x40;
	firePins |= (getpixel(x, y++)==0)? 0: 0x20;
	firePins |= (getpixel(x, y++)==0)? 0: 0x10;
	firePins |= (getpixel(x, y++)==0)? 0: 0x08;
	firePins |= (getpixel(x, y++)==0)? 0: 0x04;
	firePins |= (getpixel(x, y++)==0)? 0: 0x02;
	firePins |= (getpixel(x, y  )==0)? 0: 0x01;

	return     firePins;
} // end of getScrBits()

/*-------------------------------------------------------------------
	printImage - Graphics print function.
*/

int printImage(int left, int top, int right, int bottom) {
	int x, y, width;

	width  = right-left;

	/* Initialize line spacing to 1/8 in. (normally 1/6) for
		 Line Feeds */
	prn_putc(ESC);
	prn_putc('0');

	for (y=top; y<bottom; y+=8) {
		bitImage(width+1);

		for (x=left; x<=right; x++)
			prn_putc(getScrBits(x,y));

		prn_putc('\n');
	}
	return 0;
} // end of printImage()

//*******************************************************************
int main()
{
	int driver, mode,x,y;

	driver = DETECT;						 // autodetect
	mode = 0;
	initgraph(&driver, &mode, "c:\\tc\\tcp101\\bgi");
	x = getmaxx();
	y = getmaxy();

	// draw some things
	rectangle(0,0,x,y);
	circle(300,200,100);
	circle(210,110,50);
	circle(390,110,50);
	circle(272,173,3);
	circle(330,170,10);
	moveto(280,220);
	lineto(290,230);
	lineto(320,220);

	// Graphics print function prints entire screen
	printImage(0,0,x,y);
	closegraph();

	return 0;
} // end of main()

