/* HEAPSZ.C: Function to Find Total Far Heap Free Memory

		This function will determine how much memory is available on
		the far heap.

		Usage: To use this function you must put the statement:

												extern long heapsize(void);

										within the scope of the calling function.

		Method: The memory available on the far heap is computed by
						determining the sum of the freed blocks of memory and
						adding that amount to the value returned by coreleft().

		Input:  None.
*/

#include <alloc.h>  		// for heapinfo, heapcheck(), heapwalk(),
												// coreleft() and HEAPOK
#include <stdio.h>			// for printf()

unsigned long heapsize(void) {
	unsigned long i = 0;       // Return variable
	struct heapinfo hi;        // Value returned from farheapwalk
	hi.ptr = NULL;             // Set the beginning of farheapwalk

	if( heapcheck() <= 0 )     // Check for corrupted heap
		return (-1L);

	// Walk the heap and sum size of free blocks
	while( heapwalk(&hi) == _HEAPOK )
		if( hi.in_use == 0 )
			i += hi.size;


	// Check for amount of free memory from the highest allocated
  // to the end of DOS
	i += coreleft();

  return i;
} // end of heapsize()

//*******************************************************************
int main()
{
	unsigned long theap;
	theap = heapsize();
	printf("Heap available = %lu.\n", theap);
  return 0;
} // end of main()

