/* KEEP.C: Determining the Size of a Program at Runtime

		The size of the program can be determined by examining the size
		of the Memory Control Block (MCB) the program resides in.

		The 16 bytes immediately preceding the Program Segment Prefix
		(PSP) contain information about the Dos MCB containing your
		program. Unless the user has performed further DOS allocations
		(using allocmem() etc.), the exact size of the program in memory
		can be determined by looking at this information.

		The following code shows a structure which defines the information
		in the MCB header and gives a brief description of how to extract
		the size for use with the keep() function.
*/

#include <dos.h>   // for MK_FP, _psp and keep()

// Only 5 pertinent bytes are detailed
typedef struct {
	unsigned char mcb_type;  // 5Ah if last block in chain, else 4Dh
	unsigned owner;          // 0000 if free, 0008 if DOS
	unsigned size;           // size of MCB in paragraphs
} MCB;

//*****************************************************************
int main( void )
{
	MCB far *program_psp;

	// Install TSR
	// Make a pointer to the controlling MCB and extract the size of
	// the block from it.

	// Make pointer to MCB header then terminate & stay resident
	program_psp = (MCB far*) MK_FP(_psp-1, 0);
	keep( 0, program_psp->size );

	return 0;
} // endof main()
