/* PARPAS.C: Parent Process

    Must be compiled in a memory model which uses far pointers by
    default, i.e., compact, large or huge.
*/

#include <process.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

char string[25];

//*******************************************************************
int main(void)
{
	unsigned segment, offset, length;
	char temp[10], segoff[10];

	strcpy(string,"Parent wrote this");
	printf("%s\n",string);

	// get the segment and offset of the current string
	segment = FP_SEG(string);
	offset = FP_OFF(string);

	// convert the segment to ascii
	itoa(segment,temp,10);
	length = strlen(temp);
	segoff[0] = (char)(length + 48);
	strcpy(&segoff[1],temp);

	// convert the offset to ascii
	itoa(offset,temp,10);
	strcpy(&segoff[length+1],temp);

	// spawn the child process with the converted ascii string
	// as an argument
	spawnl(P_WAIT,"chpass.exe","chpass.exe",segoff,NULL);
	printf("%s\n",string);

	return 0;
} // end of main()
