/* QSORTEX.CPP: Modifying Online qsort() Example for C++ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Add this user defined type
typedef int (*sortFn)(const void*, const void*);

// Change sort_function to receive char* arguments
int sort_function(const char *a, const char *b);

char list[5][4] = { "cat", "car", "cab", "cap", "can" };

//*******************************************************************
int main(void) {
  int  x;

  // Use new sortFn user defined type to defeat mismatch error
  qsort((void *)list, 5, sizeof(list[0]), (sortFn)sort_function);

  for (x = 0; x < 5; x++)
    printf("%s\n", list[x]);
  return 0; 
}  // end of main()

/*-------------------------------------------------------------------
   NOTE: Due to C++'s stronger type checking, an error will be
         reported on the strcmp() line unless the const void*
         parameters in the sort_function() signature are changed
         to const char* as required by strcmp()'s prototype. */
int sort_function(const char *a, const char *b) {
  return(strcmp(a,b)); }
