/* STATIC.CPP: Initializing Static Class Members of Type Class

		 The C++ specification requires that static members of a class
		 be initialized and that this initialization be done outside of
		 the class and at global level.  Failure to do this will inevitably
		 result in an "undefined symbol" linker error.  The following code
		 illustrates the static member initialization required.

		 Note that you must declare an instance of the class in a main
		 function before TLINK will find it necessary to generate an
		 "undefined symbol" error.
*/

// declare a class
class First {
	public:
		int count;
		First() {}  //must have callable constructor
};

//declare class containing static member of class First
class Second {
	public:
		static First fVar;
};

//initialize static member of class Second
First Second::fVar = First();  //initialize with explicit call to ctor

//*******************************************************************
int main(void)
{
	Second *sVarA = new Second;
	delete sVarA;
	return 0;
} // end of main()
