/* TSRSAF.C: Writing Safe Terminate-and-Stay Resident Programs

		 This code is an example of a TSR which traps the keyboard
		 interrupt and generates some output to the screen.  It shows
		 the techniques used to deal with re-entrance and stack issues
		 (i.e. how to set up your own stack and how to set up a busy
		 flag for your code.
*/

#include <dos.h>			// for FP_SEG(), FP_OFF(), getvect(), keep()
											// setvect(), and _psp.
#include <conio.h>		// for wherex(), wherey(), cputs() and gotoxy()

#define INTR 0x09
#define ATTR 0x7900

// It is difficult to use printf() or any int21 function lower than
// 0x0C from a TSR.  Therefore we will use cprintf.

extern unsigned _heaplen = 1024;
extern unsigned _stklen  = 512;
unsigned int mystack[3000];       // This is the stack which we will use.
unsigned int oldSS;               // We'll have to save SS...
unsigned int oldSP;               // and SP.

// _9FLAG will be set so that we do not re-enter ourselves.
// If we re-enter, we will not be able to restore the old
// stack.
unsigned int x, y, _9FLAG = 0;

// A user defined type for use with getvect() & setvect()
typedef void interrupt far (*intvect)(...);

intvect oldhandler;  					     // to store old interrput

//-------------------------------------------------------------------
void interrupt handler(void) {     //  to enable C++ compilation.

	if (_9FLAG) {                    // if were already in here,
		oldhandler();
		return;
	}

	_9FLAG = 1;
	x = wherex();                  		// get cursor position
	y = wherey();
	oldSP = _SP;                   		// Save the stack
	oldSS = _SS;
	_SS = FP_SEG(mystack);         		// switch to our stack

	// Since the stack grows to lower addresses, we put the
	// end of our buffer into SP.
	_SP = FP_OFF(&mystack[2998]);

	gotoxy(72, 1);                 		// Switch cursor position
	cputs("Hello");                		// put "Hello" on the screen.
	oldhandler();
	_SS = oldSS;
	_SP = oldSP;
	gotoxy(x, y);
	_9FLAG = 0;                    		// Leaving our handler: now...
																		// ok to enter the function.
} // end of handler()

//*******************************************************************
int main(void)
{
	oldhandler = (intvect) getvect(INTR);
	setvect(INTR, (intvect)handler);
	keep(0, (_SS + (_SP/16) - _psp));
	return 0;
} // end of main()
