/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:     $RCSfile: dlist.cpp $
* Version:      $Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Member functions for the dlist class, a class designed to
*				link a series of objects together into a doubly linked
*				list. All items placed in the list MUST be derived from
*				the class DListNode.
*
* $Id: dlist.cpp 1.1 1994/03/09 12:17:58 kjb release $
*
****************************************************************************/

#include "dlist.hpp"

/*--------------------------- Member functions ----------------------------*/

// We need to instantiate the static member variable's of a class outside
// of their definitions, or they will not be able to link.

int (*GenDList::cmp)(DListNode*,DListNode*);

GenDList::GenDList()
/****************************************************************************
*
* Function:		GenDList::GenDList
*
* Description:	Constructor for the list class. We set the count of items
*				in the list to 0, and initialise the head and tail pointers
*				for the list. These both point to dummy nodes within the
*				list class, so that the dummy tail node always points to
*				itself ensuring we cannot iterate of the end of the list.
*				This also simplifies maintaining the head and tail pointers.
*
****************************************************************************/
{
	count = 0;
	head = &hz[0];				// Setup head and tail pointers
	z = &hz[1];
	head->next = z->next = z;
	z->prev = head->prev = head;
}

GenDList::~GenDList()
/****************************************************************************
*
* Function:		GenDList::~GenDList
*
* Description:	Destructor for the list class. All we do here is ask the
*				list to empty itself.
*
****************************************************************************/
{
	empty();
}

void GenDList::empty(void)
/****************************************************************************
*
* Function:		GenDList::empty
*
* Description:	Empties the list of all elements. We do this by stepping
*				through the list deleting all the elements as we go.
*
****************************************************************************/
{
	DListNode *temp;

	while (head->next != z) {
		temp = head->next;
		head->next = head->next->next;
		delete temp;
		}
	z->prev = head;
	count = 0;
}

DListNode* GenDList::merge(DListNode *a,DListNode *b,DListNode*& end)
/****************************************************************************
*
* Function:		GenDList::merge
* Parameters:	a,b		- Sublist's to merge
*				end		- Pointer to end of merged list
* Returns:		Pointer to the merged sublists.
*
* Description:	Merges two sorted lists of nodes together into a single
*				sorted list, and sets a pointer to the end of the newly
*				merged lists.
*
****************************************************************************/
{
	DListNode	*c;

	// Go through the lists, merging them together in sorted order

	c = z;
	while (a != z && b != z) {
		if (cmp(a,b) <= 0) {
			c->next = a; c = a; a = a->next;
			}
		else {
			c->next = b; c = b; b = b->next;
			}
		};

	// If one of the lists is not exhausted, then re-attach it to the end
	// of the newly merged list

	if (a != z) c->next = a;
	if (b != z) c->next = b;

	// Set end to point to the end of the newly merged list

	while (c->next != z) c = c->next;
	end = c;

	// Determine the start of the merged lists, and reset z to point to
	// itself

	c = z->next; z->next = z;
	return c;
}

void GenDList::sort(int (*cmp_func)(DListNode*,DListNode*))
/****************************************************************************
*
* Function:		GenDList::sort
* Parameters:	cmp	- Function to compare the contents of two ListNode's.
*
* Description:	Mergesort's all the nodes in the list. 'cmp' must point to
*				a comparison function that can compare the contents of
*				two ListNode's. 'cmp' should work the same as strcmp(), in
*				terms of the values it returns.
*
****************************************************************************/
{
	int			i,N;
	DListNode	*a,*b;		// Pointers to sublists to merge
	DListNode	*c;			// Pointer to end of sorted sublists
	DListNode	*todo;		// Pointer to sublists yet to be sorted
	DListNode	*t;			// Temporary

	// Set up globals required by DList::merge().

	GenDList::cmp = cmp_func;

	for (N = 1,a = z; a != head->next; N = N + N) {
		todo = head->next; c = head;
		while (todo != z) {

			// Build first sublist to be merged, and splice from main list

			a = t = todo;
			for (i = 1; i < N; i++) t = t->next;
			b = t->next; t->next = z; t = b;

			// Build second sublist to be merged and splice from main list

			for (i = 1; i < N; i++) t = t->next;
			todo = t->next; t->next = z;

			// Merge the two sublists created, and set 'c' to point to the
			// end of the newly merged sublists.

			c->next = merge(a,b,t); c = t;
			}
		}

	// After sorting the list, traverse the list from head to tail fixing
	// all the previous pointers as we go.

	a = b = head;
	b = b->next;
	while (1) {
		b->prev = a;
		if (b == z)
			break;
		a = a->next;
		b = b->next;
		}
}

// Virtual destructor for DListNode's. Does nothing.

DListNode::~DListNode()
{
}
