/*****************************************************************************
*                         Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:     $RCSfile: options.hpp $
* Version:      $Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Header file for command line parsing class. The class
*				Options is an abstract class that defines the methods
*				used to parse the command line in standard System V
*				style.
*
* $Id: options.hpp 1.1 1994/03/09 12:17:58 kjb release $
*
****************************************************************************/

#ifndef	__OPTIONS_HPP
#define	__OPTIONS_HPP

#ifndef __DEBUG_H
#include "debug.h"
#endif

#ifndef	__IOSTREAM_HPP
#include <iostream.h>
#endif

/*---------------------------- Typedef's etc -----------------------------*/

#define	OPT_ALLDONE		-1
#define	OPT_PARAMETER	-2
#define	OPT_INVALID		-3
#define	OPT_HELP		-4

#define	MAXARG		40

// Option type sepecifiers

#define	OPT_INTEGER		'd'
#define	OPT_HEX			'h'
#define	OPT_OCTAL		'o'
#define	OPT_UNSIGNED	'u'
#define	OPT_LINTEGER	'D'
#define	OPT_LHEX		'H'
#define	OPT_LOCTAL		'O'
#define	OPT_LUNSIGNED	'U'
#define	OPT_FLOAT		'f'
#define	OPT_DOUBLE		'F'
#ifdef	__MSDOS__
#define	OPT_LDOUBLE		'L'
#endif
#define	OPT_STRING		's'
#define	OPT_SWITCH		'!'

/*--------------------------- Class Definition ----------------------------*/

//---------------------------------------------------------------------------
// The following structure is used to describe each of the options to the
// options parsing routines. An array of these will need to be set up
// in the constructor call for your derived Options class below.
//---------------------------------------------------------------------------

struct Option {
	uchar	opt;				// The letter to describe the option
	uchar	type;				// Type descriptor for the option
	void	*arg;				// Place to store the argument
	char	*desc;				// Description for this option
	};

//---------------------------------------------------------------------------
// The following class is an abstract base class to provide the generalised
// methods to parse a command line. Descendants of this class will need
// to set up the optarr pointer in the constructor before parse() is
// called.
//---------------------------------------------------------------------------

class Options {
protected:
	int		nextargv;			// Variable required by getopt
	char*	nextchar;
	Option	*optarr;			// Pointer to option desciption array
	int		numopt;				// Number of options in table

			// Protected member to parse a single option
			int getopt(int argc,char** argv,char* format,char** argument);

			// Protected member to convert a single option
			int convert(const Option& option,char* argument);

			// Protected pure virtual to parse a single parameter
	virtual	int doParam(char* param,int num) = 0;

public:
			// Constructor
			Options()	{ optarr = NULL; };

			// Method to parse the command line
			int parse(int argc,char *argv[]);

			// Friend function to display usage information
	friend	ostream& operator << (ostream& o,Options& opt);
	};

#endif	// __OPTIONS_HPP
