/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:     $RCSfile: stack.hpp $
* Version:      $Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Header file for a stack class made of objects linked in
*				a singly linked list.
*
* $Id: stack.hpp 1.1 1994/03/09 12:17:58 kjb release $
*
****************************************************************************/

#ifndef	__STACK_HPP
#define	__STACK_HPP

#ifndef	__LIST_HPP
#include "list.hpp"
#endif

/*--------------------------- Class Definition ----------------------------*/

//---------------------------------------------------------------------------
// The stack class is an abstraction of the list class that provides the
// operations normally performed on a stack. Internally it is simply a
// singly linked list, so all items placed on the stack MUST be derived
// from ListNode.
//---------------------------------------------------------------------------

class GenStack : private GenList {
public:
			// Method to examine the top item on the stack
			ListNode* top() const	{ return peekHead(); };

			// Method to push an item onto the stack
			void push(ListNode* node)	{ addToHead(node); };

			// Method to pop an item from the stack
			ListNode* pop()				{ return removeFromHead(); };

			// Empties the entire stack by destroying all nodes
			void empty()				{ GenList::empty(); };

			// Returns the number of items on the stack
			ulong numberOfItems() const
				{ return GenList::numberOfItems(); };

			// Returns true if the stack is empty
			bool isEmpty() const
				{ return GenList::isEmpty(); };
	};

//---------------------------------------------------------------------------
// Template wrapper class for declaring Type Safe linked stacks.
//---------------------------------------------------------------------------

template <class T> class Stack : public GenStack {
public:
			T* top() const
				{ return (T*)GenStack::top(); };
			T* pop()
				{ return (T*)GenStack::pop(); };
	};

#endif	// __STACK_HPP
