/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: bintrtst.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Test program for the BinaryTree class.
*
* $Id: bintrtst.cpp 1.1 1994/03/09 12:19:47 kjb release $
*
****************************************************************************/

#include "debug.h"
#include "bintree.hpp"
#include <iostream.h>
#include <malloc.h>
#include <stdlib.h>

class MyNode : public BinaryTreeNode {
	int		_id;

public:
			MyNode(int id) 	{ _id = id; };
			int id() const	{ return _id; };
	virtual	~MyNode();
	virtual	int cmp(const BinaryTreeNode& node) const;
	};

MyNode::~MyNode()
{
	cout << "Deleting " << _id << endl;
}

MyNode::cmp(const BinaryTreeNode *node) const
{
	return (id() - ((MyNode*)node)->id());
}

void main(void)
{
	BinaryTree<MyNode>	tree;

}
