/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: hashtime.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Test program to time the different hash function
*				implementations.
*
* $Id: hashtime.cpp 1.1 1994/03/09 12:19:47 kjb release $
*
****************************************************************************/

#include <iostream.h>
#include <stdlib.h>
#include "hashtab.hpp"
#include <ztimer.h>

#define NUMSTRINGS	1000
#define	STRINGLEN	50

char *strings[NUMSTRINGS];

void main(void)
{
	int	i,j,len,val;

	// Build an array of random strings

	cout << endl << "Building random string table ... ";
	for (i = 0; i < NUMSTRINGS; i++) {
		len = random(STRINGLEN)+1;
		if ((strings[i] = new char[len+1]) == NULL) {
			cerr << "Out of memory!\n";
			exit(1);
			}
		for (j = 0; j < len; j++) {
			val = random(10);
			switch (val) {
				case 0:
				case 1:
				case 2:
				case 3:
				case 4:
				case 5:
				case 9:
					strings[i][j] = random('z' - 'a' + 1) + 'a';
					break;
				case 7:
				case 8:
					strings[i][j] = random('Z' - 'A' + 1) + 'A';
					break;
				case 6:
					strings[i][j] = random('?' - ' ' + 1) + ' ';
					break;
				}
			}
		strings[i][j] = '\0';
		}
	cout << "done.\n";

	// Time each of the hashing algorithms on all the strings

	cout << "hash_add(): ";
	LZTimerOn();
	for (i = 0; i < NUMSTRINGS; i++)
		hash_add(strings[i]);
	LZTimerOff();
	cout << LZTimerCount() << endl;

	cout << "hash_pjw(): ";
	LZTimerOn();
	for (i = 0; i < NUMSTRINGS; i++)
		hash_pjw(strings[i]);
	LZTimerOff();
	cout << LZTimerCount() << endl;

	cout << "hash_sa(): ";
	LZTimerOn();
	for (i = 0; i < NUMSTRINGS; i++)
		hash_sa(strings[i]);
	LZTimerOff();
	cout << LZTimerCount() << endl;

	cout << "hash_ge(): ";
	LZTimerOn();
	for (i = 0; i < NUMSTRINGS; i++)
		hash_ge(strings[i]);
	LZTimerOff();
	cout << LZTimerCount() << endl;

	cout << "hash_8(): ";
	LZTimerOn();
	for (i = 0; i < NUMSTRINGS; i++)
		hash_8(strings[i]);
	LZTimerOff();
	cout << LZTimerCount() << endl;

	cout << "hash_16(): ";
	LZTimerOn();
	for (i = 0; i < NUMSTRINGS; i++)
		hash_16(strings[i]);
	LZTimerOff();
	cout << LZTimerCount() << endl;

	cout << "hash_32(): ";
	LZTimerOn();
	for (i = 0; i < NUMSTRINGS; i++)
		hash_32(strings[i]);
	LZTimerOff();
	cout << LZTimerCount() << endl;
}
