/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: hashtst.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Test program for the hash table class.
*
* $Id: hashtst.cpp 1.1 1994/03/09 12:19:47 kjb release $
*
****************************************************************************/

#include "debug.h"
#include "hashtab.hpp"
#include <iostream.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>

// Define the nodes to be placed into the hash table

class entry : public HashTableNode {
protected:
	char	*name;			// Key of node
	int		other_stuff;
public:
			// Constructor
			entry(char *n,int stuff)
			{
				name = n;
				other_stuff = stuff;
			}

			// Destructor to delete a hash table node
			~entry();

			// Member to compute the hash value of a symbol
			uint hash(void) const;

			// Equality operator for a hash table node and a key
			bool operator == (const HashTableNode& key) const;

			// Member to display a hash table node
			void printOn(ostream& o) const;
	};

entry::~entry()
{
//	cout << "Deleting " << name << endl;
}

uint entry::hash(void) const
{
	return hash_add(name);
}

bool entry::operator == (const HashTableNode& key) const
{
	return (strcmp(name,((entry&)key).name) == 0);
}

void entry::printOn(ostream& o) const
{
	o << name << " : " << other_stuff << endl;
}

void main(int argc,char *argv[])
{
	entry	*p,*q,*r;

	cout << "\nMemory at start: " << (unsigned long)coreleft() << endl;

	// Create the hash table

	HashTable<entry>* symtab = new HashTable<entry>(31);

	// For each element on the command line, put it into the table

	for (++argv, --argc; --argc>=0; argv++)	{
		p = new entry(*argv,argc);
		symtab->add(p);
		}

	// Display the contents of the table

	cout << *symtab << endl;

	// Look up a node in the hash table

	p = new entry("in",0);
	q = symtab->find(p);

	if (q == NULL)
		cout << "Node not found.\n";
	else {
		cout << *q;
		}

	r = q;

	while ((q = symtab->next(q)) != NULL)
		cout << " and " << *q;
	cout << endl;

	// Attempt to remove the first node found

	if (r)
		delete symtab->remove(r);
	cout << *symtab << endl;

	cout << "\nMemory before deleting hash table: " << (unsigned long)coreleft() << endl;

	delete symtab;
	delete p;

	cout << "\nMemory after deleting hash table: " << (unsigned long)coreleft() << endl;
}
