//	demonstration of TreeWindow class
//	David A. Seidel 8/90

#include <keybd.h>
#include <treewind.h>
#include <strstream.h>

int popMsg (const char *msg);

int main (int argc, char *argv[])
{
	char drive;
	char buf[80];
	ostrstream msg(buf, sizeof(buf));

	drive = (argc < 2) ? (char) (getdisk() + 'A') : argv[1][0];

	msg << " Drive " << drive << ": " << ends;
	TreeWindow win(buf, 40, 1, 80, 25, 23, FrameWindow::doubleLine);
	win.load(drive);
	while (1)
	{
		int key = getkey();
		switch (key)
		{
			case UP:
				win.lineUp();
				break;
			case DOWN:
				win.lineDn();
				break;
			case PGUP:
				win.pageUp();
				break;
			case PGDN:
				win.pageDn();
				break;
			case HOME:
				win.pageTop();
				break;
			case END:
				win.pageEnd();
				break;
			case ENTER:
				msg.seekp(ios::beg);
				msg << "You selected " << win.getName() << ends;
				popMsg(buf);
				break;
			case ESC:
				return 0;
			default:
				break;
		}
	}
}

int popMsg (const char *msg)
{
	int len = strlen(msg) + 4,
		left = (maxX-len)/2,
		top = (maxY-5)/2;
	FrameWindow msgWin("", left, top, left+len, top+4, 127);
	msgWin.cursor(_NOCURSOR).scroll(0).attr(112).go(2,2);
	conout << msg;
	return getkey();
}

//	end of dtree.cpp