//	implementation of FrameWindow class
//	David A. Seidel 8/90

#include "framwind.h"

// initialize the symbol set for known frame types
boxSym FrameWindow::boxSet[numStyles] = {
	{ '', '', '', '', '', '' },
	{ '', '', '', '', '', '' },
	{ '', '', '', '', '', '' },
	{ '', '', '', '', '', '' },
	{ '', '', '', '', '', '' },
	{ '+', '+', '+', '+', '-', '|' },
	{ ' ', ' ', ' ', ' ', ' ', ' ' }
};

//	constructor
FrameWindow::FrameWindow (char *title,
						  int left, int top, int right, int bottom,
						  int attr, boxType boxT)
			: TextWindow (left+1, top+1, right-1, bottom-1, attr)
{
	UCHAR line[maxX+1];
	int width, height, len;
	boxSym& box = boxSet[boxT];
	register int i;

	curNumber = 0;

	// record the state
	window(left, top, right, bottom);
	textattr(attr);
	gettextinfo(&fState);
	frameType = boxT;

	// set up for drawing frame
	_wscroll = 0;
	width = fState.winright-fState.winleft+1;
	height = fState.winbottom-fState.wintop+1;

	// draw sides
	for (i = 2; i < height; i++)
	{
		gotoxy(1, i);
		putch(box.Vert);
		gotoxy(width, i);
		putch(box.Vert);
	}

	// draw bottom
	memset(line, box.Horiz, width);
	line[width] = '\0';
	line[0] = box.bLeft;
	line[width-1] = box.bRight;
	gotoxy(1, height);
	cputs((char *)line);

	// draw top
	len = strlen(title);
	if (len)
	{
		frameTitle = strdup(title);
		i = (width - len) / 2;
		memcpy(&line[i], title, len);
	}
	else
		frameTitle = NULL;
	line[0] = box.tLeft;
	line[width-1] = box.tRight;
	gotoxy(1, 1);
	cputs((char *)line);

	frameTitle = subTitle = frameBottom = NULL;
}

//	destructor
FrameWindow::~FrameWindow()
{
	if (frameTitle != NULL)
		free(frameTitle);
	if (subTitle != 0)
		delete subTitle;
}

//	write a subtitle (on the bottom of the frame)
int FrameWindow::writeSubTitle (char *str, justifyType just)
{
	if (subTitle != NULL)
	{
		cleanSubTitle();
		free(subTitle);
		if (frameBottom != NULL)
			free(frameBottom);
	}

	int len;
	if ((len = strlen(str)) > frameWidth()-4)
		return 0;
	curNumber = 0;
	restoreFrame();
	int size = frameWidth() * 2;
	frameBottom = (char *) malloc(size);
	gettext(fState.winleft, fState.winbottom,
			fState.winright, fState.winbottom, frameBottom);
	switch (just)
	{
		case jLeft:
			gotoxy(3, frameHeight());
			break;
		case jCenter:
			gotoxy((frameWidth()-len)/2, frameHeight());
			break;
		case jRight:
			gotoxy(frameWidth()-2, frameHeight());
			break;
	}
	conout << str;
	subTitle = new char[size];
	gettext(fState.winleft, fState.winbottom,
			fState.winright, fState.winbottom, subTitle);
	restoreState();
	return 1;
}

void FrameWindow::cleanSubTitle()
{
	if (subTitle == NULL)
		return;
	puttext(fState.winleft, fState.winbottom,
			fState.winright, fState.winbottom, frameBottom);
}

void FrameWindow::restoreSubTitle()
{
	if (subTitle == NULL)
		return;
	puttext(fState.winleft, fState.winbottom,
			fState.winright, fState.winbottom, subTitle);
}

//	framwind.cpp
