//	text window class with frames (borders)
//	derived from TextWindow class
//	David A. Seidel 8/90

#ifndef __FRAMWIND_H
#define __FRAMWIND_H

#include "textwind.h"

const int numStyles = 7;

class FrameWindow : public TextWindow
{
	public:
		struct boxSym
		{
			UCHAR tLeft, tRight,
				  bLeft, bRight,
				  Horiz, Vert;
		};

		enum boxType
		{
			singleLine, doubleLine,
			doubleOnSingle, singleOnDouble,
			big, tty, blank
		};

		enum justifyType { jLeft, jCenter, jRight };

		FrameWindow (char *title = "",
					 int left = minX, int top = minY,
					 int right = maxX, int bottom = maxY,
					 int attr = 7, boxType boxT = singleLine);

		~FrameWindow();

		//	write a subtitle on the bottom of the frame
		int		writeSubTitle (char *str, justifyType just);

	protected:
		static	boxSym		boxSet[numStyles];

		char				*frameTitle,
							*subTitle,
							*frameBottom;
		boxType				frameType;
		text_info			fState;

		int		frameWidth()	{ return fState.winright-fState.winleft+1; }
		int		frameHeight()	{ return fState.winbottom-fState.wintop+1; }
		int		frameAttr()		{ return fState.attribute; }

		void	cleanSubTitle();
		void	restoreSubTitle();

		void	restoreFrame() {
					window(fState.winleft,  fState.wintop,
				  		   fState.winright, fState.winbottom);
					textattr(fState.attribute);
				}
};

#endif

//	end of framwind.h
