#include <coniostr.h>
#include <framwind.h>

#include <dos.h>
#include <stdlib.h>
#include <keybd.h>
#include <iomanip.h>

void my_putch (unsigned char ch);

main()
{
	FrameWindow win(" Press a key ", 28, 9, 54, 16, 7, DOUBLE);
	unsigned key, scan;
	unsigned char ascii, prev = 0;

	win.home().cursor(_NOCURSOR);
	conout << endl
		   << "     Raw:" << endl
		   << "   ASCII:" << endl
		   << "    Scan:" << endl
		   << " Control:";

	while (1)
	{
		win.home();
		key = getkey();
		ascii = key & 0xff;
		scan  = key >> 8;
		if (ascii == 27 && prev == 27)
			return 0;
		prev = ascii;

		conout << endl
			   << "     Raw:   0x"
			   << setw(4) << setfill('0') << hex << key
			   << endl
			   << "   ASCII:   ";
		my_putch(ascii);
		conout << "  0x" 
			   << setw(2) << setfill('0') << hex << (unsigned) ascii
			   << "  "
			   << setw(3) << setfill(' ') << dec << (unsigned) ascii
			   << endl
			   << "    Scan:   ";
		my_putch((unsigned char)scan);
		conout << "  " 
			   << "0x" << setw(2) << setfill('0') << hex << scan
			   << "  "
			   << setw(3) << setfill(' ') << dec << scan
			   << endl
			   << " Control:  ";
		if (ascii < 32)
			conout << '^' << (char) (ascii + '@');
		else

			conout << "    ";
	}
}

void my_putch (unsigned char ch)
{
	register int x, y;

	//	get current position
	_AH = 3;
	_BH = 0;
	geninterrupt(0x10);
	x = _DL;
	y = _DH;
	++x;

	//	write character
	_AH = 0x0a;
	_AL = ch;
	_BH = 0;
	_CX = 1;
	geninterrupt(0x10);

	//	increment cursor
	_AH = 2;
	_BH = 0;
	_DH = y;
	_DL = x;
	geninterrupt(0x10);
}