//	Based on code written by Pete Becker of Borland, presented by him
//	in a public message addressed to me in the C++ message area of
//	Borland's CompuServe forum (BPROGB).

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include "memory.h"

void *BaseMem::operator new (size_t s)
{
	void *Res = ::operator new(s);
	if (Res == 0)
		quit(0);
	if (heapcheck() < 0)
		quit(1);
	return Res;
}

void BaseMem::operator delete (void *p, size_t s)
{
	if (heapchecknode(p) < 0)
		quit(1);
	else
		::operator delete(p, s);
}

void BaseMem::quit (int msg)
{
	cerr << "ERROR: ";
	if (msg == 0)
		cerr << "Unable to allocate memory.\n";
	else
		cerr << "Heap corrupted.\n";
	abort();
}
