//	text window class with frames and horizontal scrolling
//	derived from FrameWindow
//	David A. Seidel 8/90

//	Note that this is an abstract base class, due to the presence of
//	two pure virtual functions, display() and display(int).
//	The horizontal scrolling mechanism treats each line in the window
//	as a separate item, and depends on the implementation of these
//	functions to handle the details of displaying one or more lines.

#ifndef __SCRLWIND_H
#define __SCRLWIND_H

#include "framwind.h"

class ScrollWindow: public FrameWindow
{
	public:
		ScrollWindow (char *title = "",
					 int left = minX, int top = minY,
					 int right = maxX, int bottom = maxY,
					 int attr = 7, boxType boxT = singleLine,
					 int useIcons = 1);

		~ScrollWindow() { };

		//	movement methods for horizontal scrolling
		void	lineUp();
		void	lineDn();
		void	pageUp();
		void	pageDn();
		void	pageTop();
		void	pageEnd();

		void	emphasize() 	{ reDisplay(iconAttr); }
		void	highlight()		{ reDisplay(highAttr); }
		void	setNormAttr()	{ attr(normAttr); }
		void	setHighAttr()	{ attr(highAttr); }
		void	setEmphAttr()	{ attr(emphAttr); }

		void	goAway() { emphasize(); cleanSubTitle(); cleanIcons(); }
		void	comeBack() { highlight(); restoreSubTitle(); updateIcons(); }
		void	reset() { curPage = 0; }

	protected:
		int	numItems,
			curItem,
			pageSize;

		//	display attributes
		UCHAR	normAttr,
				iconAttr,
				highAttr,
				emphAttr;

		void	setScrolling(int flag)
				{
					scrollFlag = flag;
					iconFlag = flag ? 1: 0;
				}
		void	gotoItem(int n) { curItem = n; }

		void reDisplay(UCHAR specAttr);
		ScrollWindow& cleanIcons();
		ScrollWindow& updateIcons();

		virtual void display() = 0;
		virtual void display(int) = 0;

	private:
		//	page stuff
		int	scrollFlag,
			curPage,
			prevPage;

		//	icon flags
		BITFLAG iconFlag : 1;
		BITFLAG	hasUp    : 1;
		BITFLAG	hasDn    : 1;
		BITFLAG	hasTop   : 1;
		BITFLAG	hasBot   : 1;

		//	icon display methods
		ScrollWindow& putUpIcon();
		ScrollWindow& putDnIcon();
		ScrollWindow& putBegIcon();
		ScrollWindow& putEndIcon();
};

#endif

//	end of scrlwind.h
