/*
	Header file for a text window class for TC++.
	This is the base class for all other window classes
	in this library.

	Dave Seidel, 8/90
*/

#ifndef __TEXTWIND_H
#define __TEXTWIND_H

#include "coniostr.h"
#include "memory.h"
#include <stdlib.h>
#include <string.h>

extern int _wscroll;

typedef unsigned char	UCHAR;
typedef unsigned int	BITFLAG;

const int minX = 1, minY = 1,
		  maxX = 80, maxY = 25,
		  maxIn = 80, maxOut = 80;

class TextWindow : public BaseMem
{
	public:
		// constructor
		TextWindow (int left  = minX, int top    = minY,
					int right = maxX, int bottom = maxY,
					int attr  = 7);

		// destructor
		~TextWindow();

		// access methods (read-only)
		int curWin()	{ return thisNumber; }
		int curX()		{ return wState.curx; }
		int curY()		{ return wState.cury; }
		int	curWidth()	{ return wState.winright-wState.winleft+1; }
		int curHeight()	{ return wState.winbottom-wState.wintop+1; }
		int curAttr()	{ return wState.attribute; }

		// change attribute
		TextWindow& attr (int attr);
		TextWindow& attr (int fore, int back);
		TextWindow& fore (int fg);
		TextWindow& back (int bg);

		// set conio scroll flag
		TextWindow& scroll (int flag);

		// set cursor type (use <conio.h> #defines as arguments)
		TextWindow& cursor (int cursorT);

		// clear the window
		TextWindow& clear();

		// cursor movement methods
		TextWindow& go (int x, int y);
		TextWindow& home();
		TextWindow& bottom();
		TextWindow& begLine();
		TextWindow& endLine();
		TextWindow& relX (int delta_x);		// relative horizontal
		TextWindow& relY (int delta_y);		// relative vertical
		TextWindow& clrEOL();
		TextWindow& delLine();
		TextWindow& newLine();

		// string input
		TextWindow& operator>> (char *str);

		// conceal and reveal the window
		void	hide();
		void	unhide();

	protected:
		static int curNumber;

		// save/restore window data
		void refreshState() { gettextinfo(&wState); }
		void restoreState();
		void restoreOldState();

	private:
		// window index and current number
		static int wIndex;
		int thisNumber;

		// window state
		text_info wState;
		int scrollFlag;
		int cursorType;
		int checkBounds (int left, int top, int right, int bottom);

		// cursor position before window built
		text_info oldState;

		// places to save the underlying screen area
		char *saveBuffer,
			 *hideBuffer;

		// input buffer
		static char inBuf[maxIn];

};

#endif

// end of textwind.h
