/*****************************************************************************

   PROGRAM:    TLCLASS - Header File
               (C) Copyright 1992, Lindley Enterprises

   SOURCE:     TCLASS.H

   PURPOSE:    

   COMMENTS:

*****************************************************************************/

#ifndef TLCLASS_H
#define TLCLASS_H

#ifndef RC_INVOKED
#include <ldate.h>
#include <strng.h>
#include <string.h>
#include <bwindow.h>
#include <bbutton.h>

#include <mmsystem.h>
#endif

#define  STAT_TIMER          (0x1234)
#define  STAT_TIMERINT       (7)
#define  STAT_ONESECOND      (1000)

#define  SH_LEFT             (0x0000)
#define  SH_CENTER           (0x0001)
#define  SH_RIGHT            (0x0002)
#define  SH_INDENT           (0x0004)
#define  SH_RAISE            (0x0008)
#define  SH_NORMAL           (0x0010)

#define  TB_LEFT             (0x0001)
#define  TB_TOP              (0x0010)
#define  TB_RIGHT            (0x0100)
#define  TB_BASERESOURCE     (1775)
#define  TB_NUMBUTTONS       (20)

#define  WM_STATINIT         (WM_USER+10)

#define  MAX_COLORS          (16)
#define  VGA_BLACK           RGB(  0,  0,  0)
#define  VGA_DKRED           RGB(128,  0,  0)
#define  VGA_DKGREEN         RGB(  0,128,  0)
#define  VGA_TAN             RGB(128,128,  0)
#define  VGA_DKBLUE          RGB(  0,  0,128)
#define  VGA_DKPURPLE        RGB(128,  0,128)
#define  VGA_BLUEGREY        RGB(  0,128,128)
#define  VGA_DKGREY          RGB(128,128,128)
#define  VGA_LTGREY          RGB(192,192,192)
#define  VGA_RED             RGB(255,  0,  0)
#define  VGA_GREEN           RGB(  0,255,  0)
#define  VGA_YELLOW          RGB(255,255,  0)
#define  VGA_BLUE            RGB(  0,  0,255)
#define  VGA_MAGENTA         RGB(255,  0,255)
#define  VGA_CYAN            RGB(  0,255,255)
#define  VGA_WHITE           RGB(255,255,255)

DWORD far _export  GetTLClassVersion();

_CLASSDEF( TJulianDate )
class _EXPORT  TJulianDate : public Date
{
   public:
      TJulianDate();
      TJulianDate( BYTE Month, BYTE Day, UINT Year );
      TJulianDate( const Date& BD );
      TJulianDate( LPSTR lpCurDay );
      TJulianDate( LONG lDate );
      long    GetJulianDate();
      void    SetJulianDate( LONG lDate );
      UINT    GetMonthName( LPSTR szMonthName, UINT uMax );
      UINT    GetDayName( LPSTR szDayName, UINT uMax );
      UINT    GetDayOfWeek();
      UINT    GetDateString( LPSTR szDateStr, UINT uMax );
      void    SetDate( LPSTR lpBuffer );
      void    GetDate( LPSTR lpBuffer );
      void    Update();
      void operator ++(int)           { SetJulianDate( GetJulianDate()+1 ); };
      void operator --(int)           { SetJulianDate( GetJulianDate()-1 ); };
};

_CLASSDEF( TCellWnd )
class _EXPORT  TCellWnd
{
   public:
      TCellWnd( UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, UINT uType = SH_INDENT );
      virtual void    Paint( HDC hDC );
      virtual void    ForcePaint( HWND hWnd );
      void            Indent( HDC hDC );
      void            Raise( HDC hDC );
      BOOL            NeedsPaint( LPRECT pRect );
      BOOL            HitTest( UINT uXPos, UINT uYPos ) const;
      void            GetRect( LPRECT lpRect );
      void            SetRect( LPRECT lpRect, HWND hWnd );
      void            SetBackColor( COLORREF cNewBack );
      UINT            GetXStart() const                { return( uXStart ); };
      UINT            GetYStart() const                { return( uYStart ); };
      UINT            GetXEnd() const                    { return( uXEnd ); };
      UINT            GetYEnd() const                    { return( uYEnd ); };
      UINT            GetWidth()                 { return( uXEnd-uXStart ); };
      UINT            GetHeight()                { return( uYEnd-uYStart ); };
      void            SetWidth( UINT uNWidth ) { uXEnd = uXStart+uNWidth+1; };
      void            SetHeight( UINT uNHght )  { uYEnd = uYStart+uNHght+1; };
      void            SetType( UINT uType )               { uState = uType; };
      COLORREF        GetBackColor()                { return( cBackColor ); };
      BOOL            IsSortable()                         { return(FALSE); };
      int operator == ( const TCellWnd& sWnd ) const
        { return( (sWnd.uYStart == uYStart) && (sWnd.uXStart == uXStart) ); };

   private:
      BOOL            IsXBetween( UINT uBegin, UINT uEnd );
      BOOL            IsYBetween( UINT uBegin, UINT uEnd );
      UINT            uXStart;
      UINT            uYStart;
      UINT            uXEnd;
      UINT            uYEnd;
      UINT            uState;
      COLORREF        cBackColor;
};

_CLASSDEF( TCellText )
class _EXPORT  TCellText : public TCellWnd
{
   public:
      TCellText( UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, LPSTR lpTitle = NULL );
      TCellText( UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, int iNewNum = 0 );
      TCellText( UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, float fNewNum = 0.0 );
      ~TCellText();
      virtual void  Paint( HDC hDC );
      void          SetText( LPSTR lpNewText );
      void          SetMask( LPSTR lpNewMask );
      void          SetInt( int iNewNum );
      void          SetFloat( float fNewNum );
      void          SetColor( COLORREF cColor )      { cTextColor = cColor; };
      void          SetAlignment( UINT uAlign )      { uAlignment = uAlign; };
      void          SetFont( HFONT hNewFont )       { hCharFont = hNewFont; };
      int           GetInt()                           { return( iNumber ); };
      float         GetFloat()                         { return( fNumber ); };
      void          GetText( LPSTR lpData, UINT uMax )
                                         { strncpy( lpData, *pText, uMax ); };
      BOOL          IsSortable()                           { return(FALSE); };
      int operator == ( const TCellText& sText ) const
{return((sText.GetYStart()==GetYStart())&&(sText.GetXStart()==GetXStart()));};

   private:
      char          szMask[21];
      int           iNumber;
      float         fNumber;
      BOOL          bInteger;
      PString       pText;
      HFONT         hCharFont;
      UINT          uAlignment;
      COLORREF      cTextColor;
};

_CLASSDEF( TCellButton )
class _EXPORT  TCellButton : public TCellWnd
{
   public:
      TCellButton( UINT uXPos, UINT uYPos, UINT uRID, LPSTR lpNormal, LPSTR lpDisabled );
      TCellButton( UINT uXPos, UINT uYPos, UINT uRID, HBITMAP hNrm, HBITMAP hDis );
      ~TCellButton();
      virtual void  Paint( HDC hDC );
      void          Disable( HWND hParent );
      void          Enable( HWND hParent );
      BOOL          MouseMove( HWND hParent, UINT uXPos, UINT uYPos );
      BOOL          MouseDown( HWND hParent, UINT uXPos, UINT uYPos );
      BOOL          MouseUp( HWND hParent, UINT uXPos, UINT uYPos );
      BOOL          IsDown()                             { return( bDown ); };
      BOOL          IsDisabled()                     { return( bDisabled ); };
      BOOL          IsSortable()                           { return(FALSE); };
      int operator == ( const TCellButton& sText ) const
{return((sText.GetYStart()==GetYStart())&&(sText.GetXStart()==GetXStart()));};

   private:
      HBITMAP   hNormal;
      HBITMAP   hDisabled;
      BOOL      bDown;
      BOOL      bDisabled;
      BOOL      bDrawUp;
      BOOL      bCaptured;
      UINT      uResourceID;
      int       iWidth;
      int       iHeight;
};

_CLASSDEF( TStatusLine )
class _EXPORT  TStatusLine : public TBWindow
{
   public:
      TStatusLine( PTMDIFrame AFrame );
      TStatusLine( PTWindow AParent );
      ~TStatusLine();
      virtual void    Paint( HDC hDC, PAINTSTRUCT& sPaint );
      virtual void    SetupWindow();
      virtual void    ResizeStatus();
      virtual void    MoveChildren();
      void            SetText( LPSTR lpText, BOOL bEraseText );
      void            TimerMsg( RTMessage Msg ) =         [WM_FIRST+WM_TIMER];
      void            SetTextColor( COLORREF cNewColor );
      void            SetDateColor( COLORREF cNewColor );
      void            SetTimeColor( COLORREF cNewColor );
      void            GetDate( LPSTR lpDate, UINT uMax )
                                    { pDateWindow->GetText( lpDate, uMax ); };
      void            GetTime( LPSTR lpTime, UINT uMax )
                                    { pTimeWindow->GetText( lpTime, uMax ); };
      void            GetText( LPSTR lpData, UINT uMax )
                                 { pMessageWindow->GetText( lpData, uMax ); };
      WORD            GetHeight()                { return( uCharHeight+5 ); };

   protected:
      HFONT           GetTextFont()                  { return( hTextFont ); };
      PTCellText      GetMsgCell()              { return( pMessageWindow ); };
      PTCellText      GetTimeCell()                { return( pTimeWindow ); };
      PTCellText      GetDateCell()                { return( pDateWindow ); };

   private:
      BOOL            bIsMDIStatus;
      HWND            hParent;
      PTMDIFrame      pMDIParent;
      PTMDIClient     pMDIClient;
      PTWindow        pParent;
      HFONT           hTextFont;
      UINT            uCharHeight;
      UINT            uCharWidth;
      BOOL            bErase;
      UINT            uCount;
      UINT            uTimer;
      UINT            uTimeFormat;
      UINT            uDateFormat;
      PTCellText      pTimeWindow;
      PTCellText      pDateWindow;
      PTCellText      pMessageWindow;
};

_CLASSDEF( TToolBar )
class _EXPORT  TToolBar : public TBWindow
{
   public:
      TToolBar( PTMDIFrame AFrame, UINT uW, UINT uBW, UINT uBH, UINT uBS, UINT uTS, PTStatusLine pStat=NULL );
      TToolBar( PTWindow AParent, UINT uW, UINT uBW, UINT uBH, UINT uBS, UINT uTS, PTStatusLine pStat=NULL );
      ~TToolBar();
      virtual void    Paint( HDC hDC, PAINTSTRUCT& sPaint );
      virtual void    SetupWindow();
      virtual void    WMCommand( RTMessage Msg );
      virtual void    WMLButtonDown( RTMessage Msg );
      void            WMLButtonUp( RTMessage Msg )  = [WM_FIRST+WM_LBUTTONUP];
      void            WMMouseMove( RTMessage Msg )  = [WM_FIRST+WM_MOUSEMOVE];
      void            ResizeToolBar();
      UINT            GetWidth()     { return( uTSpace*2+uBWidth+uYFrame ); };
      UINT            GetHeight()   { return( uTSpace*2+uBHeight+uXFrame ); };
      void            SetButton( UINT uIndex, LPSTR lpNormal, LPSTR lpDisabled, UINT uRID );
      void            SetButton( UINT uIndex, HBITMAP hNormal, HBITMAP hDisabled, UINT uRID );
      void            ResetButton( UINT uIndex );
      void            EnableButton( UINT uIndex );
      void            DisableButton( UINT uIndex );

   protected:
      void            Repaint();

   private:
      PTMDIFrame      pMDIParent;
      HWND            hParent;
      BOOL            bIsMDIToolBar;
      PTMDIClient     pMDIClient;
      PTWindow        pParent;
      PTStatusLine    pStatus;
      UINT            uWhere;
      UINT            uBWidth;
      UINT            uBHeight;
      UINT            uBSpace;
      UINT            uTSpace;
      UINT            uXFrame;
      UINT            uYFrame;
      PTCellButton    pButtons[TB_NUMBUTTONS];
      UINT            uRIDs[TB_NUMBUTTONS];
};

_CLASSDEF( TSlideBar )
class _EXPORT  TSlideBar : public TBWindow
{
   public:
      TSlideBar( PTWindowsObject AParent, UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, UINT uRng = 100 );
      void          ShowWnd();
      void          HideWnd();
      void          SetPos( UINT uPos );
      void          SetRange( UINT uRng = 100 );
      UINT          GetRange()                          { return( uRange ); };
      UINT          GetPos()                           { return( uCurPos ); };
      void          IncPos( UINT uInc = 1 );
      virtual void  Paint( HDC hDC, PAINTSTRUCT& pStruct );

   private:
      UINT          uRange;
      UINT          uCurPos;
};

_CLASSDEF( TShadeWnd )
class _EXPORT  TShadeWnd : public TBWindow
{
   public:
      TShadeWnd( PTWindowsObject AParent, LPSTR ATitle, UINT uXPos, UINT uYPos, UINT uWidth, UINT uHeight, UINT uStyle );
      ~TShadeWnd();
      virtual void  Paint( HDC hDC, PAINTSTRUCT& pStruct );
      virtual void  SetCaption( LPSTR szCaption );
      void          SetColor( COLORREF cColor );
      void          Indent( HDC hDC );
      void          Raise( HDC hDC );
      BOOL          IsSortable()                           { return(FALSE); };
      int operator == ( const TShadeWnd& sSWnd ) const
                                      { return( sSWnd.HWindow == HWindow ); };
   private:
      UINT          uStatStyle;
      COLORREF      cTextColor;
      PString       pText;
};

_CLASSDEF( TLButton )
class _EXPORT TLButton : public TButton
{
   public:
      TLButton( PTWindowsObject AParent, int iResourceID,
                int X, int Y, int W, int H, BOOL IsDefault,
                LPSTR AUpButton, LPSTR ADownButton, PTModule AModule = NULL );
      TLButton( PTWindowsObject AParent, int iResourceID,
                LPSTR AUpButton, LPSTR ADownButton, PTModule AModule = NULL );
      TLButton( PTWindowsObject AParent, int iResourceID,
                int X, int Y, int W, int H, BOOL IsDefault,
                LPSTR AUpButton, LPSTR ADownButton,
                LPSTR AUpFocus,  LPSTR DDownFocus, PTModule AModule = NULL );
      TLButton( PTWindowsObject AParent, int iResourceID,
                LPSTR AUpButton, LPSTR ADownButton,
                LPSTR AUpFocus,  LPSTR ADownFocus, PTModule AModule = NULL );
     ~TLButton();

   protected:
      virtual void ODADrawEntire( DRAWITEMSTRUCT _FAR & DrawInfo );
      virtual void ODASelect( DRAWITEMSTRUCT _FAR & DrawInfo );

   private:
      HBITMAP  hBtnUp;
      HBITMAP  hBtnDown;
      HBITMAP  hBtnUpFocus;
      HBITMAP  hBtnDownFocus;
      int      iWidth;
      int      iHeight;
};

_CLASSDEF( TBitmap )
class TBitmap
{
   public:
      TBitmap( LPSTR lpFileName );
      ~TBitmap();
      BOOL              DibInfo( HANDLE hDIB, LPBITMAPINFOHEADER lpBInfo );
      HPALETTE          CreateBIPalette( LPBITMAPINFOHEADER lpBInfo );
      HPALETTE          CreateDibPalette( HANDLE hDIB );
      HANDLE            ReadDibBitmapInfo( int iFile );
      WORD              PaletteSize( LPBITMAPINFOHEADER lpBInfo );
      WORD              DibNumColors( LPVOID lpHeader );
      HBITMAP           BitmapFromDib( HANDLE hDIB, HPALETTE hPal );
      BOOL              Draw( HDC hDC, int iX, int iY );
      DWORD             LongRead( int iFile, LPVOID lpBuffer, DWORD dwLength );
      int               Type()                  { return( sBitmap.bmType ); };
      int               Width()                { return( sBitmap.bmWidth ); };
      int               Height()              { return( sBitmap.bmHeight ); };
      BYTE              Planes()              { return( sBitmap.bmPlanes ); };
      BYTE              BitsPixel()        { return( sBitmap.bmBitsPixel ); };

   private:
      BOOL              bOpen;
      BOOL              bDrawn;
      HBITMAP           hBitmap;  // Handle to Bitmap
      BITMAP            sBitmap;
};

#endif
