// ObjectWindows - (C) Copyright 1992 by Borland International

/* this example is a modified MDIAPP that creates, for the third child
   window window, a transparent window. For this test, the transparent
   Window responds to WM_ERASEBKGND, returning True. Another approach
   would be the use of a NULL_BRUSH. The Transparent Window is created
   maximized, which allows users to view but not select the Windows
   underneath. Allowing the user to move the transparent window will
   cause odd painting of the transparent and successive child Windows.
   A general comment on transparent windows follows.

 Windows 3.1 does not support fully functional transparent windows.
 Note that when a window is created using CreateWindowEx() with the 
 WS_EX_TRANSPARENT style, windows below it at the position where the 
 original window was initially placed are not obscured and show through. 
 Moving the WS_EX_TRANSPARENT window, however, results in the old window 
 background  moving to the new position, because Windows does not support 
 fully  functional transparent windows. 
 WS_EX_TRANSPARENT was designed to be used in very modal situations and the 
 lifetime of a window with this style must be very short. A good use of this 
 style is for drawing tracking points on the top of another window. For 
 example, a dialog editor would use it to draw tracking points around the 
 control that is being selected or moved. 

*/
#include <owl.h>
#include <mdi.h>

// Define a TApplication descendant
class TMDIApp : public TApplication {
public:
    TMDIApp(LPSTR name, HINSTANCE hInstance,
		  HINSTANCE hPrevInstance, LPSTR lpCmd,
		  int nCmdShow)
	        : TApplication(name, hInstance,
			       hPrevInstance, lpCmd, nCmdShow) {};
    virtual void InitMainWindow();
};
class TMyMDIClient : public TMDIClient
{
 public:
  TMyMDIClient( PTMDIFrame p )
   : TMDIClient( p )
   {
     Attr.Style |= MDIS_ALLCHILDSTYLES;
   }
}
// Define a TMDIFrame descendant
class TMyMDIFrame : public TMDIFrame {
public:
  WORD ChildNum;

  TMyMDIFrame(LPSTR ATitle, LPSTR MenuName);
  virtual PTWindowsObject InitChild();
  virtual void InitClientWindow()
  {
   ClientWnd = new TMyMDIClient
};
class TTransChild: public TWindow
{
 public:
  TTransChild( PTWindowsObject AParent, LPSTR ATitle)
	: TWindow( AParent, ATitle )
 {
  Attr.Style = WS_CLIPSIBLINGS | WS_VISIBLE | WS_CHILDWINDOW |
    WS_CAPTION |WS_MINIMIZEBOX | WS_MAXIMIZEBOX | WS_THICKFRAME | WS_MAXIMIZE;
 };

 virtual void WMEraseBackground( RTMessage Msg )
 = [ WM_FIRST + WM_ERASEBKGND ]
 {
  Msg.Result = True;
  return;
  }


};

// Construct the TMDIApp's MainWindow object, loading its menu
void TMDIApp::InitMainWindow()
{
  MainWindow = new TMyMDIFrame("MDI Conformist", "MDIMenu");
}

TMyMDIFrame::TMyMDIFrame(LPSTR ATitle, LPSTR MenuName)
             : TMDIFrame(ATitle, MenuName)
{

  ChildNum = 1;
}
PTWindowsObject TMyMDIFrame::InitChild()
{
  char ChildName[25];
  PTWindowsObject ptr;

  if( ChildNum == 3 )
  {
  wsprintf(ChildName,"Transparent Child");
  ptr = (PTWindowsObject)new TTransChild( this, ChildName );
  ChildNum++;
  }
  else
  {
  wsprintf(ChildName,"MDI Child %d", ChildNum++);
  ptr = new TWindow(this, ChildName);
  }
 return ptr;
}

// Run the MDIApp
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpCmd, int nCmdShow)
{
    TMDIApp MDIApp ("MDIApp", hInstance, hPrevInstance,
		lpCmd, nCmdShow);
    MDIApp.Run();
    return (MDIApp.Status);
}
//========================================================================
//  This example has been provided by the Technical Support staff at 
//  Borland International. Examples are provided as a courtesy and not as 
//  part of a Borland product, and as such, are provided without the 
//  assurance of technical support or any specific  guarantees.
//========================================================================
