//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.
#include "storage.h"
#include <iostream.h>

void storage_gencode()
{
	bt_C<storage_C>();
}


ecode(storage_page_B,ECODE_F)
{
	storage_page_C* stopag= (storage_page_C*) a;
	int n;
	for (n=0;n<n_elements;n++) {
		//stcon.itself() is delivery skipped
		gencode.dr_code(stopag[n].next_page());
		gencode.dr_code(stopag[n].size());
		gencode.dr_code(stopag[n].type());
		gencode.dr_code(stopag[n].level());
		if(gencode.operation!=DECODE)
		  gencode.dr_code(stopag[n].data.info->elements);
		else {
		  int elements;
		  gencode.dr_code(elements);
		  stopag[n].data.create(elements);
		}
		gencode.dr_code(stopag[n].data(),stopag[n].data.info->elements);
	}
	return 1;
}


storage_page_C::storage_page_C()
{
	init();
}

void storage_page_C::set_type(char type_param)
{
	type()=(char)type()|type_param;
}

void storage_page_C::clear_type(char type_param)
{
	type()=type()&~type_param;
}

void storage_page_C::init(int data_size)
{
	itself.create();next_page.create();
	type.create();data.create(data_size);
	size.create();
	level.create();
	clear();
}

void storage_page_C::clear(void)
{
	itself()=next_page()=0;
	size()=0;
	type()=0;
	level()=1;
}

storage_page_C& storage_page_C::operator=(u_long_B position)
{
	itself()=position();
	return *this;
}


ecode(storage_control_B,ECODE_F)
{
	storage_control_C* stocon= (storage_control_C*) a;
	int n;
	for (n=0;n<n_elements;n++) {
		gencode.dr_code(stocon[n].rl_c());
		gencode.dr_code(stocon[n].wl_trans());
		gencode.dr_code(stocon[n].dl());
		gencode.dr_code(stocon[n].saved());
		if(gencode.operation!=DECODE)
		  gencode.dr_code(stocon[n].data.info->elements);
		else {
		  int elements;
		  gencode.dr_code(elements);
		  stocon[n].data.create(elements);
		}
		gencode.dr_code(stocon[n].data(),stocon[n].data.info->elements);
	}
	return 1;
}



ecode(storage_control_header_B,ECODE_F)
{
	storage_control_C* stocon= (storage_control_C*) a;
	int n;
	for (n=0;n<n_elements;n++) {
		gencode.dr_code(stocon[n].rl_c());
		gencode.dr_code(stocon[n].wl_trans());
		gencode.dr_code(stocon[n].dl());
		gencode.dr_code(stocon[n].saved());
	}
	return 1;
}


storage_control_C::storage_control_C()
{
	rl_c.create();
	wl_trans.create();
	dl.create();
	saved.create();
	clear();
}

void storage_control_C::clear(void)
{
	rl_c()=0;
	wl_trans()=0;
	dl()=0;
	saved()=0;
	data.forget();
}


storage_trans_control_C::storage_trans_control_C()
{
	trans.create();
	operation.create();
	prev_entry.create();
	pos.create();
	level.create();
	clear();
}

void storage_trans_control_C::clear()
{
	trans()=0;
	operation()=0;
	prev_entry()=0;
	pos()=0;
	level()=0;
	data.forget();
}


int storage_C::open(char *nom_arch, int mode_param)
{
	int n;
	if (!open_count()) {
		name()=nom_arch;
		mode()=mode_param;
		if (mode()==USE) {
			file()=fopen(name(),"r+b");
			if (!file()) return 0;
		}

		if (mode()==CREATE) {
			file()=fopen(name(),"w+b");
			mode()=CREATE;
		}
		if (!file())
			throw file_except_C(OPEN_FILE_EXCEPT);
		open_count()++;
		{
			 storage_page_B page;
			 u_long_B   u_long_v;
			 page.create();
			 page().init(data_size());
			 page_size.create();
			 page_size()=page.size();
			 u_long_v.create();
			 u_long_size.create();
			 u_long_size()=u_long_v.size();
		}

		root_page.create(levels()+trans());
		root_page_lt.create(levels()+trans());
		tail.create();
		last_page.create();
		state.create();
		active_trans.create();
		active_trans()=0;

		if (mode()==CREATE) {
			tail()=0;
			last_page()=0;
			for(n=0;n<levels()+trans();n++){
				root_page(n)=0;
				root_page_lt(n)=0;
			}
			state()=0;
			root_page.encode(file());
			root_page_lt.encode(file());
			tail.encode(file());
			last_page.encode(file());
			state.encode(file());
			first_page()=ftell(file());
			{
				storage_page_B page;
				page.create();
				page().init(data_size());
				create(page);
				del(page);
			} //to ensure at least one page in the storage
		}
		else {
			u_long_B fpos;
			u_long_B prev_state;
			fpos.create();
			root_page.decode(file());
			root_page_lt.decode(file());
			tail.decode(file());
			last_page.decode(file());
			fpos()=ftell(file());
			state.decode(file());
			prev_state.clone(state);
			state()=0;
			fseek(file(),fpos(),SEEK_SET);
			state.encode(file());
			first_page()=ftell(file());

			if (!prev_state()) {
				stabilize();
			}
		}


	}
	fflush(file());
	return 1;
}

int storage_C::close()
{
  if(open_count()==0) return 1;
  if(open_count()==1) {
			fseek (file(),0,SEEK_SET);
			root_page.encode(file());
			root_page_lt.encode(file());
			tail.encode(file());
			last_page.encode(file());
			state()=1;
			state.encode(file());
			fclose(file());
			file()=NULL;
			open_count()--;
			return 1;
  }
  open_count()--;
  return 0;
}


int storage_C::stabilize()
{
	 u_long_B rec_ptr;
	 storage_page_B page;
	 storage_page_B cursor_page;
	 page.create();
	 cursor_page.create();
	 page().init(data_size());
	 cursor_page().init(data_size());
	 tail()=0;
	 last_page()=0;

	 if (first(page)) {
		 do {
#ifdef 	DEBUG_STORAGE_STABILIZE
			 cout<<(int)page().type()<<":"<<page().itself()<<"\n";
#endif
			 page().clear_type(storage_page_C::CK_PAGE);
			 write(page);
		 } while (next(page));
	 }
	 else return 0;
	last_page()=page().itself();
	first(page);
	do {
		if (!(page().type()&storage_page_C::PARENT_PAGE)) continue;
		if (page().type()&storage_page_C::DEL_PAGE) continue;
#ifdef 	DEBUG_STORAGE_STABILIZE
			 cout<<(int)page().type()<<":"<<page().itself()<<"\n";
#endif
		page().set_type(storage_page_C::CK_PAGE);
		write(page);
		cursor_page.clone(page);
		while(cursor_page().next_page()) {
			if(page().type()&storage_page_C::DEL_PAGE) break;
#ifdef 	DEBUG_STORAGE_STABILIZE
			 cout<<(int)page().type()<<":"<<page().itself()<<"\n";
#endif
			cursor_page().itself()=cursor_page().next_page();
			read(cursor_page);
			cursor_page().set_type(storage_page_C::CK_PAGE);
			write(cursor_page);
		}
	} while (next(page));

	tail()=0;
	first(page);
	do {
		if (!(page().type()&(char)storage_page_C::CK_PAGE) ||
		  (page().level()>=levels() &&  !root_page(page().level()))) {
#ifdef 	DEBUG_STORAGE_STABILIZE
			 cout<<(int)page().type()<<":"<<page().itself()<<"\n";
#endif
			if(fseek(file(),last_page()+page_size()+tail()*u_long_size(),
			SEEK_SET)) throw file_except_C(SEEK_FILE_EXCEPT);
			page().itself.encode(file());
			tail()++;
			page().set_type(storage_page_C::DEL_PAGE);
			write(page);
		}
	} while (next(page));
	for (int n=levels();n<levels()+trans();n++)
					 commit_trans(n);
	return 1;
}


void storage_C::set_level(int level_param)
{
	if (level_param==-1) level()=default_level();
	else level()=level_param;
}


void storage_C::init(int data_size_param,int default_level_param,
							int levels_param,int trans_param)
{
	data_size.create();
	name.create();
	file.create(),open_count.create(),mode.create(),level.create();
	default_level.create();
	first_page.create();
	levels.create();
	trans.create();
	data_size()=data_size_param;
	file()=NULL;
	level()=1;
	default_level()=default_level_param;
	levels()=levels_param;
	trans()=trans_param;
	open_count()=0;
	mode()=0;
}


storage_C::~storage_C()
{
  if (data_size.is_void()) return;
  while (!close());
}

storage_C::storage_C():file(BT_BA)
{}

int storage_C::first(u_long_B& pos,int level_param)
{
	 set_level(level_param);
	 storage_page_B  page;
	 storage_control_header_B header;
	 page.create();
	 page().init(data_size());
	 char invalid=(char)storage_page_C::SUN_PAGE |
					  (char)storage_page_C::DEL_PAGE ;
	 if (!first(page)) return 0;;
	 do {
		 if (page().type()&(char)storage_page_C::PARENT_PAGE)
			 header.decode(&page().data);
		 else
			 header.create();
	 }while((page().type()&invalid ||
			  page().level()!=level() ||
			  header().dl()) && next(page));
	 if (page().type()&invalid || page().level()!=level() || header().dl() ||
		  !(page().type()&(char)storage_page_C::PARENT_PAGE)) return 0;
	 pos()=page().itself();
	 return 1;
}

int storage_C::last(u_long_B& pos,int level_param)
{
	 set_level(level_param);
	 storage_page_B  page;
	 storage_control_header_B header;
	 page.create();
	 page().init(data_size());
	 char invalid=(char)storage_page_C::SUN_PAGE |
					  (char)storage_page_C::DEL_PAGE ;
	 if (!last(page)) return 0;
	 do {
		 if (page().type()&(char)storage_page_C::PARENT_PAGE)
			 header.decode(&page().data);
		 else
			 header.create();
	 }while((page().type()&invalid ||
			 page().level()!=level() ||
			 header().dl()) && prev(page)) ;
	 if (page().type()&invalid || page().level()!=level() || header().dl() ||
		  !(page().type()&(char)storage_page_C::PARENT_PAGE)) return 0;
	 pos()=page().itself();
	 return 1;
}

int storage_C::next  (u_long_B& pos,int level_param)
{
	 set_level(level_param);
	 storage_page_B  page;
	 storage_control_header_B header;
	 page.create();
	 page().init(data_size());
	 page()=pos;
	 read(page);
	 char invalid=(char)storage_page_C::SUN_PAGE |
					  (char)storage_page_C::DEL_PAGE;
	 if(!next(page)) return 0;
	 do  {
#ifdef  DEBUG_STORAGE_NEXT
		 cout<<(int)page().type()<<":"<<page().itself()<<"\n";
#endif
		 if (page().type()&(char)storage_page_C::PARENT_PAGE)
			 header.decode(&page().data);
		 else
			 header.create();
	 } while((page().type()&invalid ||
			 page().level()!=level() ||
			 header().dl()) && next(page));
	 if (page().type()&invalid || page().level()!=level() || header().dl() ||
		  !(page().type()&(char)storage_page_C::PARENT_PAGE)) return 0;
	 pos()=page().itself();
	 return 1;
}

int storage_C::prev(u_long_B& pos,int level_param)
{
	 set_level(level_param);
	 storage_page_B  page;
	 storage_control_header_B header;
	 page.create();
	 page().init(data_size());
	 page()=pos;
	 read(page);
	 char invalid=(char)storage_page_C::SUN_PAGE |
					  (char)storage_page_C::DEL_PAGE;
	 if(!prev(page)) return 0;
	 do {
		 if (page().type()&(char)storage_page_C::PARENT_PAGE)
			 header.decode(&page().data);
		 else
			 header.create();
	 } while((page().type()&invalid ||
			 page().level()!=level() ||
			 header().dl()) && prev(page));
	 if (page().type()&invalid || page().level()!=level() || header().dl() ||
		  !(page().type()&(char)storage_page_C::PARENT_PAGE)) return 0;
	 pos()=page().itself();
	 return 1;
}

int storage_C::first(void* dato,u_long_B& pos,int level_param,int trans_param)
{

	 set_active_trans(trans_param);
	 set_level(level_param);
	 if (!first(pos)) return 0;
	 return get(dato,pos);
}

int storage_C::last(void* dato,u_long_B& pos,int level_param,int trans_param)
{
	 set_active_trans(trans_param);
	 set_level(level_param);
	 if (!last(pos)) return 0;
	 return get(dato,pos);
}

int storage_C::next(void* dato,u_long_B& pos,int level_param,int trans_param)
{
	 set_active_trans(trans_param);
	 set_level(level_param);
	 if (!next(pos)) return 0;
	 return get(dato,pos);
}

int storage_C::prev(void* dato,u_long_B& pos,int level_param,int trans_param)
{
	set_active_trans(trans_param);
	set_level(level_param);
	if  (!prev(pos)) return 0;
	return get(dato,pos);
}

int storage_C::first_rl(void* dato,u_long_B& pos,int level_param,
								int trans_param)
{

	 set_active_trans(trans_param);
	 set_level(level_param);
	 if (!first(pos)) return 0;
	 return get_rl(dato,pos);
}

int storage_C::last_rl(void* dato,u_long_B& pos,int level_param,int trans_param)
{
	 set_active_trans(trans_param);
	 set_level(level_param);
	 if (!last(pos)) return 0;
	 return get_rl(dato,pos);
}

int storage_C::next_rl(void* dato,u_long_B& pos,int level_param,int trans_param)
{
	 set_active_trans(trans_param);
	 set_level(level_param);
	 if (!next(pos)) return 0;
	 return get_rl(dato,pos);
}

int storage_C::prev_rl(void* dato,u_long_B& pos,int level_param,int trans_param)
{
	set_active_trans(trans_param);
	set_level(level_param);
	if  (!prev(pos)) return 0;
	return get_rl(dato,pos);
}

int storage_C::first_wl(void* dato,u_long_B& pos,int level_param,int trans_param)
{

	 set_active_trans(trans_param);
	 set_level(level_param);
	 if (!first(pos)) return 0;
	 return get_wl(dato,pos);
}

int storage_C::last_wl(void* dato,u_long_B& pos,int level_param,int trans_param)
{
	 set_active_trans(trans_param);
	 set_level(level_param);
	 if (!last(pos)) return 0;
	 return get_wl(dato,pos);
}

int storage_C::next_wl(void* dato,u_long_B& pos,int level_param,int trans_param)
{
	 set_active_trans(trans_param);
	 set_level(level_param);
	 if (!next(pos)) return 0;
	 return get_wl(dato,pos);
}

int storage_C::prev_wl(void* dato,u_long_B& pos,int level_param,int trans_param)
{
	set_active_trans(trans_param);
	set_level(level_param);
	if  (!prev(pos)) return 0;
	return get_wl(dato,pos);
}


int storage_C::add_trans(storage_trans_control_B& trans_param,int operation)
{
	u_long_B pos;
	pos.create();
	trans_param().operation()=operation;
	trans_param().trans()=active_trans();
	trans_param().prev_entry()=root_page(active_trans());
	put_nt(&trans_param,pos,active_trans());
	set_root_nt(pos,active_trans());
#ifdef DEBUG_ADD_TRANS
	cout<<"DEBUG_ADD_TRANS:"<<trans_param().trans()
		 <<":"<<trans_param().operation()
		 <<":"<<trans_param().level()<<":"
		 <<trans_param().prev_entry()<<":"
		 <<trans_param().pos()<<"\n";
#endif
	return 1;
}

int storage_C::begin_trans()
{
	int n;
	for (n=levels();n<(levels()+trans()) && root_page(n);n++)
	if (n==levels()+trans()) return 0;
	storage_trans_control_B trans_var;
	u_long_B pos;
	trans_var.create();
	pos.create();
	trans_var().trans()=n;
	set_active_trans(n);
	add_trans(trans_var,BEGIN_TRANS);

	return n;
}

int storage_C::end_trans(int trans_param,char commit_f)
{
	set_active_trans(trans_param);
	if  (!root_page(active_trans())) return 0;
	storage_trans_control_B trans_var;
	trans_var.create();
	add_trans(trans_var,END_TRANS);
	if (commit_f) commit_trans(active_trans());
	return 1;
}

int storage_C::commit_trans(int trans_param)
{
	set_active_trans(trans_param);
	u_long_B pos,root;
	storage_trans_control_B trans_var;
	storage_control_B stocon;
	pos.create();
	root.create();
	root()=pos()=root_page(active_trans());
	if(root()) {
#ifdef DEBUG_COMMIT
	cout<<"ROOT:"<<root()<<"\n";
#endif	
		get_nt(&trans_var,pos,active_trans());
		if (trans_var().operation()!=END_TRANS) { //undo transaction
			for(;;) {
				undo(trans_var);
				pos.clone(trans_var().prev_entry);
				if(!pos()) break;
				get_nt(&trans_var,pos,active_trans());
			}
		}
		else{  //terminate transaction
			for (;;) {
				commit(trans_var);
#ifdef DEBUG_COMMIT
	cout<<"DEBUG_COMMIT   :"<<trans_var().trans()<<":"<<trans_var().operation()
		 <<":"<<trans_var().level()<<":"<<trans_var().prev_entry()<<"\n";
#endif
				pos.clone(trans_var().prev_entry);

				if (!pos()) break;
				get_nt(&trans_var,pos,active_trans());
			}
		}
		pos.create();
		pos()=0;
		set_root_nt(pos,active_trans());
		pos.clone(root);
		for(;;) {
			get_nt(&trans_var,pos,active_trans());
			root.clone(trans_var().prev_entry);
			del_nt(pos,active_trans());
			pos.clone(root);
			if(!pos()) break;
		}
		return 1;
	}
	return 0;
}

int storage_C::undo(storage_trans_control_B& trans_param)
{
	storage_control_B stocon;
	u_long_B pos;
	switch(trans_param().operation()) {
		case RL_TRANS:
			get_nt(&stocon,trans_param().pos,trans_param().level());
			if (stocon().rl_c()>0) {
				stocon().rl_c()--;
				modify_nt(&stocon,trans_param().pos,trans_param().level());
			}
			return 1;
		case WL_TRANS:
			get_nt(&stocon,trans_param().pos,trans_param().level());
			if (stocon().wl_trans()) {
				stocon().wl_trans()=0;
				modify_nt(&stocon,trans_param().pos,trans_param().level());
			}
			return 1;
		case DL_TRANS:
			get_nt(&stocon,trans_param().pos,trans_param().level());
			if (stocon().dl()) {
				stocon().dl()=0;
				modify_nt(&stocon,trans_param().pos,trans_param().level());
			}
			return 1;
		case MODIFY_TRANS:
			if (!trans_param().data.is_void()) {
				 stocon.decode(&trans_param().data);
				 stocon().wl_trans()=0;
				 modify_nt(&stocon,trans_param().pos,trans_param().level());
			}
			return 1;
		case PUT_TRANS:
			del_nt(trans_param().pos,trans_param().level());
			return 1;
		case ROOT_TRANS:
			root_page_lt(trans_param().level())=0;
			set_root_nt(trans_param().pos,trans_param().level());
			return 1;
		case BEGIN_TRANS:
			root_page_lt(trans_param().trans())=0;
			pos.create();
			pos()=0;
			set_root_nt(pos,trans_param().trans());
			return 1;
	}
	return 0;
}

int storage_C::commit(storage_trans_control_B& trans_param)
{
	storage_control_B stocon;
	u_long_B pos;
	switch(trans_param().operation()) {
		case RL_TRANS:
			get_nt(&stocon,trans_param().pos,trans_param().level());
			if (stocon().rl_c()>0) {
				stocon().rl_c()--;
				modify_nt(&stocon,trans_param().pos,trans_param().level());
			}
			return 1;
		case WL_TRANS:
			get_nt(&stocon,trans_param().pos,trans_param().level());
			if (stocon().wl_trans()) {
				stocon().wl_trans()=0;
				modify_nt(&stocon,trans_param().pos,trans_param().level());
			}
			return 1;
		case DL_TRANS:
			get_nt(&stocon,trans_param().pos,trans_param().level());
			if (stocon().dl()) {
				stocon().dl()=0;
				modify_nt(&stocon,trans_param().pos,trans_param().level());
			}
			return 1;
		case MODIFY_TRANS:
		case PUT_TRANS:
			get_nt(&stocon,trans_param().pos,trans_param().level());
			if (stocon().wl_trans()) {
				if (stocon().wl_trans() || stocon().saved()) {
					stocon().wl_trans()=0;
					stocon().saved()=0;
					modify_nt(&stocon,trans_param().pos,trans_param().level());
				}
			}
			return 1;
		case ROOT_TRANS:
			root_page_lt(trans_param().level())=0;
			pos.create();
			pos()=root_page(trans_param().level());
			set_root_nt(pos,trans_param().level());
			return 1;
		case BEGIN_TRANS:
			root_page_lt(trans_param().trans())=0;
			pos.create();
			pos()=0;
			set_root_nt(pos,trans_param().trans());
			return 1;
	}
	return 0;
}

int storage_C::set_active_trans(int  n)
{
	if (n==-1) return 1;
	if(n>=levels() && n<(levels()+trans())) {
		active_trans()=n;
		return 1;
	}
	if (n==0) {
		active_trans()=0;
		return 1;
	}
	else return 0;
}

int storage_C::get(void* dato,u_long_B& pos, int level_param,int trans_param)
{
	storage_control_B stocon;
	gen_P data= (gen_P) dato;
	set_active_trans(trans_param);

	get_nt(&stocon,pos,level_param);
	data->decode(&stocon().data);
	if((stocon().wl_trans()&& active_trans()!=stocon().wl_trans()) ||
	   stocon().dl()) return 0;
	return 1;
}

int storage_C::get_rl(void* dato,u_long_B& pos, int level_param,int trans_param)
{
	storage_control_B stocon;
	storage_trans_control_B trans_var;
	gen_P data= (gen_P) dato;
	set_active_trans(trans_param);


	if (!active_trans())
		return 0;
	else {
		get_nt(&stocon,pos,level_param);
		if(stocon().wl_trans() || stocon().dl()) return 0;
		stocon().rl_c()++;
		trans_var.create();
		trans_var().pos.clone(pos);
		add_trans(trans_var,RL_TRANS);
		modify_nt(&stocon,pos,level_param);
		return data->decode(&stocon().data);
	}
}

int storage_C::get_wl(void* dato,u_long_B& pos, int level_param,int trans_param)
{
	storage_control_B stocon;
	storage_trans_control_B trans_var;
	gen_P data= (gen_P) dato;
	set_active_trans(trans_param);


	if (!active_trans()) {
		return 0;
	}
	else {
		get_nt(&stocon,pos,level_param);
		if((stocon().wl_trans() && stocon().wl_trans()!=active_trans()) ||
			 stocon().dl() || stocon().rl_c())
			 return 0;
		stocon().wl_trans()=active_trans();
		trans_var.create();
		trans_var().pos.clone(pos);
		add_trans(trans_var,WL_TRANS);
		modify_nt(&stocon,pos,level_param);
		return data->decode(&stocon().data);
	}
}

int storage_C::modify(void* dato,u_long_B& pos, int level_param,int trans_param)
{
	storage_control_B stocon;
	storage_trans_control_B trans_var;
	gen_P data= (gen_P) dato;
	set_active_trans(trans_param);


	if (!active_trans()) {
		get_nt(&stocon,pos,level_param);
		if(stocon().wl_trans() || stocon().dl() || stocon().rl_c()) return 0;
		data->encode(&stocon().data);
		modify_nt(&stocon,pos,level_param);
		return 1;
	}
	else {
		get_nt(&stocon,pos,level_param);
#ifdef DEBUG_STORAGE_MODIFY
	cout<<"DEBUG_STORAGE_MODIFY:"
		 <<stocon().wl_trans()<<":"<<level_param<<":"<<(int)stocon().dl()<<":"
		 <<stocon().rl_c()<<"\n";
#endif
		if((stocon().wl_trans() && stocon().wl_trans()!=active_trans()) ||
			 stocon().dl() || stocon().rl_c())
			 return 0;
		trans_var.create();
		trans_var().pos.clone(pos);
		if(!stocon().saved()) stocon.encode(&trans_var().data);
		add_trans(trans_var,MODIFY_TRANS);
		stocon().wl_trans()=active_trans();
		stocon().saved()=1;
		data->encode(&stocon().data);
		modify_nt(&stocon,pos,level_param);
		return 1;
	}
}

int storage_C::put(void* dato,u_long_B& pos, int level_param,int trans_param)
{
	storage_control_B stocon;
	storage_trans_control_B trans_var;
	storage_page_B pc;
	gen_P data= (gen_P) dato;
	set_active_trans(trans_param);


	if (!active_trans()) {
		stocon.create();
		data->encode(&stocon().data);
		put_nt(&stocon,pos,level_param);
		return 1;
	}
	else {
		stocon.create();
		data->encode(&stocon().data);
		stocon().wl_trans()=active_trans();
		put_nt(&stocon,pos,level_param,pc);
		trans_var.create();
		trans_var().level()=level_param;
		trans_var().pos.clone(pos);
		add_trans(trans_var,PUT_TRANS);
		commit_put_nt(pc);
		return 1;
	}
}

int storage_C::del (u_long_B& pos, int level_param,int trans_param)
{
   storage_control_B stocon;
   storage_trans_control_B trans_var;
   set_active_trans(trans_param);


   if(!active_trans()) {
      return del_nt(pos,level_param);
   }
   else {
      get_nt(&stocon,pos,level_param);
		if(stocon().rl_c() || stocon().dl() ||
		   (stocon().wl_trans() && stocon().wl_trans()!=active_trans())) return 0;
      stocon().dl()=1;
		trans_var.create();
		trans_var().level()=level_param;		
      trans_var().pos.clone(pos);
      add_trans(trans_var,DL_TRANS);
      modify_nt(&stocon,pos,level_param);
		return 1;
   }
}

int storage_C::set_root(u_long_B&  pos, int level_param,int trans_param)
{
   storage_trans_control_B trans_var;
   set_active_trans(trans_param);

   if(!active_trans()) {
      return set_root_nt(pos,level_param);
   }
   else {
      trans_var.create();
      trans_var().pos()=root_page(level_param);
      add_trans(trans_var,ROOT_TRANS);
      root_page_lt(level_param)=1;
      set_root_nt(pos,level_param);
      return 1;
   }
}


int storage_C::get_root(u_long_B& pos, int level_param,int trans_param)
{
      set_active_trans(trans_param);
      if (!root_page_lt(level_param)) {
          pos()=root_page(level_param);
          return 1;
      }
      else
      if (active_trans()==0) {
         pos()=root_page(level_param);
         return 0;
      }
      return 0;
}

int storage_C::get_nt(void* dato,u_long_B& pos,int level_param)
{
   set_level(level_param);
   storage_page_B page;
   static int debu_f=0;
   int n,i;
	int size;
   char_B  data;
	gen_P gen;
   gen=(gen_P)dato;
   page.create();
   page().init(data_size());
   page()=pos;
   read(page);
   if (debu_f) cout<<(page().type()&storage_page_C::SUN_PAGE)<<"|"
                   <<(page().type()&storage_page_C::DEL_PAGE)<<"|"
                   <<!(page().type()&storage_page_C::PARENT_PAGE)<<"|"
                   <<(page().level()!=level())<<"\n";
   if (page().type()&storage_page_C::SUN_PAGE  ||
       page().type()&storage_page_C::DEL_PAGE  ||
     !(page().type()&storage_page_C::PARENT_PAGE) ||
     page().level()!=level() )
     return 0;
   size=page().size();
   data.create(size);
   char * des=&data();
   char * ori=&page().data();
   for(n=0,i=0;n<size;n++,i++) {
		if(i==data_size()) {
         i=0;
			page()=page().next_page;
         if (!page().itself()) return 0;
         read(page);
         ori=&page().data();
      }
      des[n]=ori[i];
   }
   return gen->decode(&data);
}


int storage_C::put_nt(void* dato,u_long_B& pos, int level_param)
{
      storage_page_B page;
      put_nt(dato,pos,level_param,page);
      commit_put_nt(page);
      return 1;
}


int storage_C::put_nt(void* dato,u_long_B& pos,int level_param,
                      storage_page_B& pc)
{
   set_level(level_param);
   int i,n;
   int size;
   u_long_B page_ant;
	gen_P gen;
   gen=(gen_P)dato;
   storage_page_B page,parent_page,new_page;
   page.create();
   page().init(data_size());
   char_B data;
   gen->encode(&data);
   size=data.elements();
   create(page);
   page().size()=size;
   parent_page=page;
   pos()=page().itself();
   char * ori=&data();
   char * des=&page().data();
   for(n=0,i=0;n<size;n++,i++) {
		if(i==data_size()) {
         i=0;
			new_page.create();
         new_page().init(data_size());
         create(new_page);
			new_page().set_type(storage_page_C::SUN_PAGE);
			if (new_page().type()&storage_page_C::LAST_PAGE)
				page().clear_type(storage_page_C::LAST_PAGE);
			page().next_page()=new_page().itself();
			write(page);
			page=new_page;
			des=&page().data();
		}
		des[i]=ori[n];
	}
	write(page);
	pc=parent_page;
	return 1;
}

int storage_C::commit_put_nt(storage_page_B& pc)
{
	if(pc().itself()!=last_page())
	   pc().clear_type(storage_page_C::LAST_PAGE);
   pc().set_type(storage_page_C::PARENT_PAGE);
   write(pc);
	return 1;
}

int storage_C::modify_nt(void* dato,u_long_B& pos,int level_param)
{
   set_level(level_param);
   int i,n;
   int size;
   u_long_B page_ant;
   gen_P gen;
   gen=(gen_P)dato;
   storage_page_B page,new_page,parent_page;
   page.create();
   page().init(data_size());
	page()=pos;
	char_B data;
	gen->encode(&data);
   size=data.elements();
   read(page);
   if(!(page().type()&storage_page_C::PARENT_PAGE) ||
       page().level()!=level())
		return 0;
	page().clear_type(storage_page_C::PARENT_PAGE);
   page().size()=size;
	write(page);
   parent_page=page;
   char * ori=&data();
   char * des=&page().data();
   for(n=0,i=0;n<size;n++,i++) {
      if(i==data_size()) {
         i=0;
         if (!page().next_page()) {
            new_page.create();
            new_page().init(data_size());
            create(new_page);
            new_page().set_type(storage_page_C::SUN_PAGE);
            page().next_page()=new_page().itself();
            write(page);
            page=new_page;
				des=&page().data();
         }
         else {
            new_page.create();
            new_page().init(data_size());
				new_page()=page().next_page;
            read(new_page);
				if(!(new_page().type()&storage_page_C::SUN_PAGE)) return 0;
            write(page);
            page=new_page;
            des=&page().data();
		  }
      }
      des[i]=ori[n];
   }
   write(page);
   parent_page().set_type(storage_page_C::PARENT_PAGE);
   write(parent_page);
   return 1;
}

int storage_C::del_nt(u_long_B& pos,int level_param)
{
   set_level(level_param);
	u_long_B next_page;
   next_page.create();
   storage_page_B page;
	page.create();
   page().init(data_size());
	page()=pos;
   read(page);
   if (!(page().type()&storage_page_C::PARENT_PAGE) || page().level()!=level())
          return 0;
   next_page()=page().next_page();
   del(page);
   while (next_page()) {
      page()=next_page;
		read(page);
		if (!(page().type()&storage_page_C::SUN_PAGE)) return 0;
		next_page()=page().next_page();
		del(page);
	}
	return 1;
}

int storage_C::set_root_nt(u_long_B& pos,int level_param)
{
	 set_level(level_param);
	 root_page(level())=pos();
	 fseek(file(),0,SEEK_SET);
	 root_page.encode(file());
	 root_page_lt.encode(file());
	 fflush(file());
	 return 1;
}

//***************************************
// Private metods
//***************************************


int storage_C::create(storage_page_B& page)
{
  u_long_B rec_ptr;
  char create_f=0;
  rec_ptr.create();

  page().clear();
  page().level()=level();

  if (tail()) {
	  if (fseek(file(),last_page()+page_size()+(tail()-1)*u_long_size(),
			SEEK_SET))
		  return 0;
	  rec_ptr.decode(file());
	  tail()--;
	#ifdef DEBUG_STORAGE_CREATE_PAGE
	 printf("reuse:%lu\n",rec_ptr());
	#endif
  }
  else {
	  if(!last_page())  {
		  fseek(file(),0,SEEK_END);
		  rec_ptr()=ftell(file());
	  }
	  else
		  rec_ptr()=last_page()+page_size();
	  create_f=1;
	#ifdef DEBUG_STORAGE_CREATE_PAGE
	 printf("create:%lu\n",rec_ptr());
	#endif
  }
  page()=rec_ptr;
  if(create_f || (page().itself()==last_page()))
	  page().set_type(storage_page_C::LAST_PAGE);
  write(page);
#ifdef 	DEBUG_STORAGE_CREATE_PAGE
			 cout<<(int)page().type()<<":"<<page().itself()<<"\n";
#endif
  if(create_f) {
	  if(last_page()) {
		  storage_page_B temp_page;
		  temp_page.create();
		  temp_page().init(data_size());
		  temp_page().itself()=last_page();
		  read(temp_page);
#ifdef 	DEBUG_STORAGE_CREATE_PAGE
			 cout<<(int)temp_page().type()<<":"<<temp_page().itself()<<"\n";
#endif
		  temp_page().clear_type(storage_page_C::LAST_PAGE);
		  write(temp_page);
#ifdef 	DEBUG_STORAGE_CREATE_PAGE
			 cout<<(int)temp_page().type()<<":"<<temp_page().itself()<<"\n";
			 temp_page().clear();
			 temp_page().itself()=last_page();
			 read(temp_page);
			 cout<<(int)temp_page().type()<<":"<<temp_page().itself()<<"\n";
#endif
		  fflush(file());
	  }
	  last_page()=page().itself();
  }
  return 1;
}

int storage_C::del(storage_page_B&  page)
{
	u_long_B rec_ptr;
	if(page().type()&storage_page_C::DEL_PAGE) return 0;
	if(fseek(file(),last_page()+page_size()+tail()*u_long_size(),
		SEEK_SET)) throw file_except_C(SEEK_FILE_EXCEPT);
	rec_ptr=page().itself;
	rec_ptr.encode(file());
	#ifdef DEBUG_PAGE
	 printf("delete:%lu\n",page().itself());
	#endif
	tail()++;
	page().set_type(storage_page_C::DEL_PAGE);
	if (page().itself()==last_page())
	  page().set_type(storage_page_C::DEL_PAGE);

	write(page);
	return 1;
}

int storage_C::write(storage_page_B& page)
{
#ifdef 	DEBUG_STORAGE_WRITE_PAGE
	cout<<"STORAGE_WRITE_PAGE:";
	cout<<(int)page().type()<<":"<<page().itself()<<"\n";
#endif
	if (fseek(file(),page().itself(),SEEK_SET)) {
		throw file_except_C(WRITE_FILE_EXCEPT);
	}
	else
		page.encode(file());
	fflush(file());
	return 1;
}

int storage_C::read(storage_page_B& page)
{
	u_long_B paso;
	paso.create();
	paso()=page().itself();
	if (fseek(file(),page().itself(),SEEK_SET)) {
		throw file_except_C(READ_FILE_EXCEPT);
	}
	else  {
		page.decode(file());
		page().itself()=paso();
	}
	return 1;

}


int storage_C::first(storage_page_B& page)
{
	u_long_B position;
	position.create();
	position()=first_page();
	page()=position;
	return read(page);
}

int storage_C::next(storage_page_B& page)
{
	#ifdef 	DEBUG_STORAGE_NEXT_PAGE
			 cout<<(int)page().type()<<":"<<page().itself()<<"\n";
	#endif
	if(page().type()&(char)storage_page_C::LAST_PAGE) return 0;
	else page().itself()+=page_size();
	return read(page);
}

int storage_C::prev(storage_page_B& page)
{
	if(page().itself()==first_page()) return 0;
	else page().itself()-=page_size();
	return read(page);
}


int storage_C::last(storage_page_B& page)
{
	if(!last_page()) return 0;
	page()=last_page;
	return read(page);
}

