#define STRICT
#define WIN31


#include <owl.h>
#include <edit.h>
#include <combobox.h>
#include <ctype.h>
#include "validate.h"



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TApp : public TApplication
{
    public:
        TApp( LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
              LPSTR lpCmdLine, int nCmdShow) :
        TApplication(AName, hInstance, hPrevInstance,
                     lpCmdLine, nCmdShow)
        {};
        virtual void InitMainWindow();
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TValidEdit : public TEdit
{
        int   nDefButtonID;
    public:
        TValidEdit( PTWindowsObject AParent, int ResourceId, WORD ATextLen,
                    PTModule AModule = NULL ) :
        TEdit( AParent, ResourceId, ATextLen, AModule )
        {
        }
        virtual void WMKillFocus( RTMessage msg ) = [ WM_FIRST + WM_KILLFOCUS ]
        {
            DefWndProc( msg );
            if ( EditValidate() != TRUE  )
            {
                PostMessage( Parent->HWindow, WM_NEXTDLGCTL,
                             (WPARAM)HWindow, TRUE );
                MessageBeep( 0 );
            }
        }
        virtual BOOL EditValidate()  = 0;
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TValidCombo : public TComboBox
{
        int   nDefButtonID;
    public:
        TValidCombo( PTWindowsObject AParent, int ResourceId, WORD ATextLen,
                     PTModule AModule = NULL ) :
        TComboBox( AParent, ResourceId, ATextLen, AModule )
        {
        }
        virtual void WMKillFocus( RTMessage msg ) = [ WM_FIRST + WM_KILLFOCUS ]
        {
            DefWndProc( msg );
            if ( ComboValidate() != TRUE  )
            {
                PostMessage( Parent->HWindow, WM_NEXTDLGCTL,
                             ( WPARAM )HWindow, TRUE );
                MessageBeep( 0 );
            }
        }
        virtual BOOL ComboValidate()  = 0;
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TNumberCombo : public TValidCombo
{
    public:
        TNumberCombo( PTWindowsObject AParent, int ResourceId, WORD ATextLen,
                      PTModule AModule = NULL ) :
        TValidCombo( AParent, ResourceId, ATextLen, AModule )
        {}
        virtual BOOL ComboValidate( void );
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TNumberEdit : public TValidEdit
{
    public:
        TNumberEdit( PTWindowsObject AParent, int ResourceId, WORD ATextLen,
                     PTModule AModule = NULL ) :
        TValidEdit( AParent, ResourceId, ATextLen, AModule )
        {}
        virtual BOOL EditValidate( void );
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
BOOL TNumberEdit::EditValidate( void )
{
    BOOL fValid  = TRUE;
    char *p = new char[ GetTextLen()+1];
    if ( p )
    {
        if ( GetText( p, GetTextLen()+1 ) != 0 )
        {
            char *q = p;
            while ( isdigit( *q )  &&  *q)
                q++;
            fValid = ( *q == '\0' );
        }
        delete []p;
    }
    return( fValid );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
BOOL TNumberCombo::ComboValidate( void )
{
    BOOL fValid  = TRUE;
    char *p = new char[ GetTextLen()+1];
    if ( p )
    {
        if ( GetText( p, GetTextLen()+1 ) != 0 )
        {
            char *q = p;
            while ( isdigit( *q )  &&  *q )
                q++;
            fValid = ( *q == '\0' );
        }
        delete []p;
    }
    return( fValid );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TUpperEdit : public TValidEdit
{
    public:
        TUpperEdit( PTWindowsObject AParent, int ResourceId, WORD ATextLen,
                    PTModule AModule = NULL ) :
        TValidEdit( AParent, ResourceId, ATextLen, AModule )
        {}
        virtual BOOL EditValidate( void );
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
BOOL TUpperEdit::EditValidate( void )
{
    BOOL fValid  = TRUE;
    char *p = new char[ GetTextLen()+1];
    if ( p )
    {
        if ( GetText( p, GetTextLen()+1 ) != 0 )
        {
            char *q = p;
            while ( isupper( *q )  &&  *q )
                q++;
            fValid = ( *q == '\0' );
        }
        delete []p;
    }
    return( fValid );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
class TLowerEdit : public TValidEdit
{
    public:
        TLowerEdit( PTWindowsObject AParent, int ResourceId, WORD ATextLen,
                    PTModule AModule = NULL ) :
        TValidEdit( AParent, ResourceId, ATextLen, AModule )
        {}
        virtual BOOL EditValidate( void );
};



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
BOOL TLowerEdit::EditValidate( void )
{
    BOOL fValid  = TRUE;
    char *p = new char[ GetTextLen()+1];
    if ( p )
    {
        char *q = p;
        if ( GetText( p, GetTextLen()+1 ) != 0 )
        {
            while( islower( *q )  &&  *q )
                q++;
            fValid = ( *q == '\0' );
        }
        delete []p;
    }
    return( fValid );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
void TApp::InitMainWindow()
{
    MainWindow = new TDialog( NULL, "MainDialog" );
    new TNumberEdit( MainWindow, ID_NUMBER, 0 );
    new TUpperEdit ( MainWindow, ID_UPPER, 0 );
    new TLowerEdit ( MainWindow, ID_LOWER, 0 );
}



// ------------------------------------------------------------------ //
//                                                                    //
// ------------------------------------------------------------------ //
int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow)
{
    TApp App ( "Sample App", hInstance, hPrevInstance,
               lpCmdLine, nCmdShow);
    App.Run();
    return( App.Status );
}
