@echo off
echo.
echo Create Windows DLL C Library
echo ----------------------------
echo.
if %2.==. goto HELP

rem Set lib names
rem -------------
set _EXELIB_=%2libcw.lib
set _DLLLIB_=%2dllcw0.lib
set _FINALLIB_=%2dllcw.lib
set _FINALBAK_=%2dllcw.bak
set _TMPLIB_=xwindllx.lib
set _TMPBAK_=xwindllx.bak

echo Building %1\%_FINALLIB_%...
echo.

rem Copy static lib to temp lib
rem ---------------------------

copy %1\%_EXELIB_% %1\%_TMPLIB_%

rem Remove unwanted objects from static lib
rem ---------------------------------------

lib /NOE  %1\%_TMPLIB_% @%1\wincdll.bld;

rem Put the cleansed static lib and the dll core lib together
rem ---------------------------------------------------------

if exist %1\%_FINALLIB_% copy %1\%_FINALLIB_% %1\%_FINALBAK_%
if exist %1\%_FINALLIB_% del %1\%_FINALLIB_%
lib /NOE %1\%_FINALLIB_% + %1\%_DLLLIB_% +%1\%_TMPLIB_%;

rem Clean up
rem --------

del %1\%_TMPLIB_%
del %1\%_TMPBAK_%

echo Done building %1\%_FINALLIB_%

set _EXELIB_=
set _DLLLIB_=
set _FINALLIB_=
set _FINALBAK_=
set _TMPLIB_=
set _TMPBAK_=

rem All done!
rem ---------
goto EXIT


:HELP
echo Wincdll builds a Win DLL C component library (?dllcw.lib) from
echo a Win EXE C component library (?libcw.lib).
echo.
echo	   wincdll  "pathname"	"model"
echo.
echo where:
echo.
echo	   "pathname" = complete pathname of library directory
echo			(wincdll.bld must reside there also)
echo.
echo	   "model"    = memory model (s, m, c, or l)
echo.
:EXIT
