	page	,132
	title	cputs - buffered console output
;***
;cputs.asm - direct console output
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines cputs() - write string directly to console
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include os2dll.inc
	.list


	externP _putch

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _cputs(string) - put a string to the console
;
;Purpose:
;	Writes the string directly to the console.  No newline
;	is appended.
;
;Entry:
;	char *string - string to write
;
;Exit:
;	Good return = 0
;	Error return = !0
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_cputs,<PUBLIC>,<si>

	parmDP	string

cBegin

if	sizeD
	les	si,string
	STRSEG	equ  <ES:>	; segment string is in
else
	mov	si,string
	STRSEG	equ  <DS:>	; string in DGROUP
endif

lupe:
	xor	ax,ax
	lods	byte ptr STRSEG[si] ; get a byte (zero-extended)
	or	al,al		; see if it's the terminating null
	jz	short toend

if sizeD
	push	es		; save es
endif
	push	ax
	callcrt __putch 	; output the char
	inc	ax		; test for return value of -1
	pop	bx		; clean up stack
if sizeD
	pop	es		; restore es
endif
	jnz	lupe
				; error...

	mov	ax,-1		; error value = -1
	jmp	short done	; return error
toend:
	xor	ax,ax		; good return = 0

;Common return code
done:


cEnd

sEnd

	end
