	page	,132
	title	cgets - buffered keyboard input
;***
;cgets.asm - buffered keyboard input
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines cgets() - read a string directly from console
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include msdos.inc
include defsegs.inc
.list

ifndef _WINDOWS
	_DEBUGSCREEN equ 1		; debug screen swapping
endif

ifdef _DEBUGSCREEN
CrtDefSegs <dbdata>

sBegin	dbdata				;
	assumes ds,data 		; Used to do the running under
externW 	__aDBswpflg		; a debugger screen swapping
externW 	__aDBswpchk		;
sEnd	dbdata				;
	extrn	__aDBdoswp:ABS		;
endif	; _DEBUGSCREEN

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;char *_cgets(string) - read string from console
;
;Purpose:
;	Reads a string from the console via the DOS buffered keyboard input
;	function.  string[0] must contain the maximum length of the
;	string.  Returns pointer to str[2].
;
;Entry:
;	char *string - place to store read string, str[0] = max length.
;
;Exit:
;	returns pointer to str[2], where the string starts.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_cgets,<PUBLIC>,<di>

	parmdp	string

cBegin

ifdef _DEBUGSCREEN
	cmp	__aDBswpflg,__aDBdoswp	; Aware debugger as parent?
	jne	@F			; No -- skip
	push	bx		; save register
	mov	bx,-1		; force screen swap always
	call	__aDBswpchk		; Yes -- see if we need to swap screens
	pop	bx
@@:
endif	; _DEBUGSCREEN

if	sizeD
	push	ds
	lds	dx,string
else
	mov	dx,string
endif

	push	ds
	pop	es		; make es point to proper seg too
	callos	bufkbdin	; buffered keyboard input
	mov	di,dx		; &string[0]
	mov	cl,[di] 	; maxchar
	xor	ch,ch
	inc	di
	inc	di		; &string[2]
	mov	al,0dh		; ascii <cr>
repne	scasb			; find the <cr>
	dec	di		; di points to <cr>
	mov	byte ptr [di],0 ; make the <cr> a null byte
	mov	ax,dx		; &string[0]
	inc	ax
	inc	ax		; &string[2]

if	sizeD
	mov	dx,ds		; seg part
	pop	ds
endif

cEnd

sEnd
	end
