	page	,132
	title	getch - read a character from stdin (getche - same with echo)
;***
;getch.asm - contains getch() and getche() for DOS 3
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	The routines "getch()" and "getche()" reads a single character
;	from standard input, without and with echo, respectively.
;
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include msdos.inc
include defsegs.inc
.list


ifndef _WINDOWS
	_DEBUGSCREEN equ 1		; debug screen swapping
endif


ifdef _DEBUGSCREEN
CrtDefSegs <dbdata>

sBegin	dbdata				;
	assumes ds,data 		; Used to do the running under
externW 	__aDBswpflg		; a debugger screen swapping
externW 	__aDBswpchk		;
sEnd	dbdata				;
	extrn	__aDBdoswp:ABS		;
endif	;_DEBUGSCREEN

sBegin	data
	assumes ds,data

	public	__chbuf
__chbuf dw	-1		; Push-back buffer used by "ungetch()"

sEnd

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _getch(), _getche() - read character from std input (without and with echo)
;
;Purpose:
;	If the "ungetch()" push-back buffer is not empty (empty==-1) Then
;	    Mark it empty (-1) and RETURN the value that was in it
;
;	Else Read a Character using Int 21h Function 8 (getch) or 1 (getche)
;	    and return it
;
;Entry:
;	None, reads from std input.
;
;Exit:
;	AL = next byte from console, AH = 0
;	Static variable "__chbuf" may be altered
;
;Uses:
;	DX
;
;Exceptions:
;
;*******************************************************************************

	public	__getch
	public	__getche

__getche:
	mov	dh,1h		; read keyboard and echo
	jmp	short getch_start

__getch:
	mov	dh,8h		; read keyboard and do not echo

getch_start:

cProc	dummy,<>,<>

cBegin	<nogen>
;
; If [__chbuf] != -1 Then the low byte is a character that has been pushed
; back by a call to ungetch() and is the value that should be returned.
;
	mov	ax,[__chbuf]
	or	ah,ah		; see if byte pushed back by ungetch
	jnz	tocon

	mov	[__chbuf],-1	; -1 means [__chbuf] is empty
	jmp	short done

tocon:

ifdef _DEBUGSCREEN
	cmp	__aDBswpflg,__aDBdoswp	; Aware debugger as parent?
	jne	@F			; No -- skip
	push	bx		; save register
	mov	bx,-1		; must swap screen
	call	__aDBswpchk	; Yes -- see if we need to swap screens
	pop	bx		; restore saved register
@@:
endif	; _DEBUGSCREEN


	xchg	ax,dx		; load AH with INT 21H function number (1 or 8)
	callos
fin:
	mov	ah,0		; return the byte in AL
done:
	ret
cEnd	<nogen>

sEnd
	end
