	page	,132
	title	int86 - interrupt with given registers
;***
;int86.asm - do 8086 interrupt with given registers
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines int86() - do 8086 interrupt with given regs
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	.list

OFFAX	=	0
OFFBX	=	2
OFFCX	=	4
OFFDX	=	6
OFFSI	=	8
OFFDI	=	10
OFFC	=	12

externP _maperror

ifdef _WINDOWS
extrn	ALLOCDSTOCSALIAS:far
extrn	FREESELECTOR:far
endif

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;void _int86(intno, inregs, outregs) - do 8086 interrupt
;
;Purpose:
;	Loads the register values specified in inregs, execute the
;	corresponding 8086 interrupt, and copies the resulting
;	register values to outregs.
;
;Entry:
;	int intno - interrupt number
;	union REGS *inregs - register to load for call
;	union REGS *outregs - resulting registers
;
;Exit:
;	returns value in AX after the call
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_int86,<PUBLIC>,<di,si>

	parmw	intno
	parmdp	inregs
	parmdp	outregs

cBegin
;
; the stack is made to look like this:
;
;	-------------------
;	|     outregs	  |  (arg3)
;	-------------------
;	|     inregs	  |  (arg2)
;	-------------------
;	|     intno	  |  (arg1)
;	-------------------
;	|    ret addr	  |
;	-------------------
;  bp-> |     old bp	  |
;	-------------------
;	|     old di	  |
;	-------------------
;	|     old si	  |
;	-------------------
;	| 'retf'|	  |
;	-------------------
;	| 'inc sp inc sp' |  <- only in if int 25 or int 26
;	-------------------
;	| 'int'  | intno  |  <- we do a long call to 'int' opcode
;	-------------------
;	|	ss	  |
;	-------------------
; (bp)->| offset of 'int' |
;	-------------------

	sub	sp,10		; room for 5 words
	mov	byte ptr [bp-10],0cdh ; an 'int' opcode
	mov	ax,intno
	mov	[bp-9],al	; the interrupt number
	cmp	al,25h
	je	abnorm
	cmp	al,26h
	je	abnorm
	mov	byte ptr [bp-8],0cbh ; a 'retf' opcode
	jmp	short continue

abnorm:
	mov	byte ptr [bp-6],0cbh ; a 'retf' opcode
	mov	byte ptr [bp-7],044h ; a 'inc sp' opcode for flags on stack
	mov	byte ptr [bp-8],044h ; a 'inc sp' opcode for flags on stack

continue:

ifdef	_WINDOWS
	push	ss
	call	ALLOCDSTOCSALIAS; can't exec code on stack
        mov     [bp-0ch],ax     ; seg part of far call addr, using CS alias
else
	mov	[bp-0ch],ss	; seg part of far call addr
endif

	lea	ax,[bp-10]	; offset part of far call addr
	mov	[bp-0eh],ax	; we're going to jump onto the stack

if	sizeD
	push	ds		; save ds
	lds	di,inregs	; get union REGS addr
else
	mov	di,inregs	; get union REGS addr
endif

	mov	ax,[di+OFFAX]
	mov	bx,[di+OFFBX]
	mov	cx,[di+OFFCX]
	mov	dx,[di+OFFDX]
	mov	si,[di+OFFSI]
	mov	di,[di+OFFDI]

if	sizeD
	pop	ds		; restore ds
endif

	push	bp
	clc			; clear carry before int
	call	dword ptr [bp-0eh] ; execute the interrupt
	pop	bp		; bp points to old bp
	cld

if	sizeD
	push	ds		; save ds before di so it's on bottom
endif

	push	di		; save di

if	sizeD
	lds	di,outregs	; get union REGS addr
else
	mov	di,outregs	; get union REGS addr
endif

	mov	[di+OFFAX],ax
	mov	[di+OFFBX],bx
	mov	[di+OFFCX],cx
	mov	[di+OFFDX],dx
	mov	[di+OFFSI],si
	pop	[di+OFFDI]	; restore di

ifdef	_WINDOWS
	push	ax		; save return value
	lahf
	push	ax		; save carry flag
	push	[bp-0ch]
	call   FREESELECTOR	; free DS-to-CS alias selector
	pop	ax		; restore carry flag
	sahf
	pop	ax		; restore return value
endif

	jc	carry		; test carry flag

	xor	si,si
	jmp	short toend

carry:
if	sizeD
	pop	cx
	push	cx		; cx = DGROUP = word on tos
	push	ds		; save segment of REGS parameter
	mov	ds,cx		; restore ds to DGROUP
endif

	callcrt __maperror

if	sizeD
	pop	ds		; restore segment of REGS parameter
endif
	mov	si,1
	mov	ax,[di+OFFAX]	; restore ax after mapping error

toend:
	mov	[di+OFFC],si	; set carry/no carry flag

if	sizeD
	pop	ds		; restore ds
endif

	add	sp,10		; to get back to old sp

cEnd

sEnd
	end
