	page	,132
	title	intdos - dos function call with given registers
;***
;intdos.asm - call int 21h (dos function)
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines intdos() - call int 21h
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	.list


OFFAX	=	0
OFFBX	=	2
OFFCX	=	4
OFFDX	=	6
OFFSI	=	8
OFFDI	=	10
OFFC	=	12

externP _maperror


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _intdos(inregs, outregs) - call DOS (int 21h)
;
;Purpose:
;	Invoke DOS (int 21h) with the given registers, and
;	save the output registers (and carry flag) in outregs.
;
;Entry:
;	union REGS *inregs - register to call int 21h with
;	union REGS *outregs - registers on output of int 21h
;
;Exit:
;	returns value in AX.  If carry flag is set, _doserrno
;	is set to the dos error number.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_intdos,<PUBLIC>,<di,si>

	parmdp	inregs
	parmdp	outregs

cBegin

if	sizeD
	push	ds		; save ds
	lds	di,inregs	; get union REGS addr
else
	mov	di,inregs	; get union REGS addr
endif

	mov	ax,[di+OFFAX]
	mov	bx,[di+OFFBX]
	mov	cx,[di+OFFCX]
	mov	dx,[di+OFFDX]
	mov	si,[di+OFFSI]
	mov	di,[di+OFFDI]

if	sizeD
	pop	ds		; restore ds
endif

	callos			; make dos function call

if	sizeD
	push	ds		; save ds before di so it's on bottom
endif

	push	di		; save di

if	sizeD
	lds	di,outregs	; get union REGS addr
else
	mov	di,outregs	; get union REGS addr
endif

	mov	[di+OFFAX],ax
	mov	[di+OFFBX],bx
	mov	[di+OFFCX],cx
	mov	[di+OFFDX],dx
	mov	[di+OFFSI],si
	pop	[di+OFFDI]	; restore di
	jc	carry

	xor	si,si
	jmp	short toend

carry:
if	sizeD
	pop	ds
	push	ds
endif

	callcrt __maperror
if	sizeD
	lds	di,outregs
endif

	mov	si,1
	mov	ax,[di+OFFAX]	; restore ax after mapping error

toend:
	mov	[di+OFFC],si	; set carry/no carry flag

if	sizeD
	pop	ds		; restore ds
endif

cEnd

sEnd
	end
