	page	,132
	title	intdosx - dos function call with given registers
;***
;intdosx.asm - invoke DOS (int 21h) with register and seg regs
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines intdosx() - call int 21h with regs and seg regs
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	.list

OFFAX	=	0
OFFBX	=	2
OFFCX	=	4
OFFDX	=	6
OFFSI	=	8
OFFDI	=	10
OFFC	=	12

OFFES	=	0
OFFDS	=	6

externP _maperror


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _intdosx(inregs, outregs, segregs) - invoke DOS with given regs
;
;Purpose:
;	Invokes a DOS call (int 21h) with given registers and segments
;	registers.  After call, registers (and carry flag) are copied
;	into outregs and segment registers are copied back into segregs.
;	Only DS and ES from segment registers are used.
;
;Entry:
;	union REGS *inregs - registers to call DOS with
;	union REGS *outregs - registers and CF returned from DOS
;	struct SREGS *segregs - segment registers on entry/exit
;				(only DS, ES used)
;
;Exit:
;	returns the value in AX after the call.  If CF is set,
;	_doserrno is set to corresponding error code.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_intdosx,<PUBLIC>,<di,si>

	parmdp	inregs
	parmdp	outregs
	parmdp	segregs

ifdef	_WINDOWS
ife	sizeD
	localW	saveds
endif
endif

cBegin

if	sizeD
	push	ds
else
ifdef	_WINDOWS
	mov	[saveds],ds	; save ds for later
endif
endif

if	sizeD
	lds	di,inregs	; get union REGS addr
else
	mov	di,inregs	; get union REGS addr
endif

	mov	ax,[di+OFFAX]
	mov	bx,[di+OFFBX]
	mov	cx,[di+OFFCX]
	mov	dx,[di+OFFDX]
	mov	si,[di+OFFSI]
	push	[di+OFFDI]	; save di, need it for indexing

if	sizeD
	lds	di,segregs
else
	mov	di,segregs
endif

	mov	es,[di+OFFES]
	mov	ds,[di+OFFDS]
	pop	di		; restore di
	callos			; make dos function call
	push	di		; save di
	push	ds

if	sizeD
	lds	di,segregs	; get struct SREGS addr
else
ifdef	_WINDOWS
	mov	ds,[saveds]	; restore ds from stack
else
	mov	di,ss		; reset ds from ss
	mov	ds,di		; in case dos function call smashed ds
endif
	mov	di,segregs	; get struct SREGS addr
endif

	mov	[di+OFFES],es
	pop	[di+OFFDS]

if	sizeD
	lds	di,outregs	; get union REGS addr
else
	mov	di,outregs	; get union REGS addr
endif

	mov	[di+OFFAX],ax
	mov	[di+OFFBX],bx
	mov	[di+OFFCX],cx
	mov	[di+OFFDX],dx
	mov	[di+OFFSI],si
	pop	[di+OFFDI]	; restore di
	jc	carry

	xor	si,si
	jmp	short toend

carry:
if	sizeD
	pop	ds
	push	ds
endif

	callcrt __maperror
if	sizeD
	lds	di,outregs
endif
	mov	si,1
	mov	ax,[di+OFFAX]	; restore ax after mapping error

toend:
	mov	[di+OFFC],si	; set carry/no carry flag

if	sizeD
	pop	ds
endif

cEnd

sEnd
	end
