	page	,132
	title	kbhit - check keyboard status
;***
;kbhit.asm - check if key has been pressed
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines kbhit() - check if key has been pressed
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include msdos.inc
include defsegs.inc
.list


ifndef _WINDOWS
	_DEBUGSCREEN equ 1		; debug screen swapping
endif


ifdef _DEBUGSCREEN
CrtDefSegs <dbdata>

sBegin	dbdata				;
	assumes ds,data 		; Used to do the running under
externW 	__aDBswpflg		; a debugger screen swapping
externW 	__aDBswpchk		;
sEnd	dbdata				;
	extrn	__aDBdoswp:ABS		;
endif	; _DEBUGSCREEN

sBegin	data
	extrn	__chbuf:word	; Push-back buffer (-1 == empty)
sEnd

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _kbhit() - checks the console for pending keystroke
;
;Purpose:
;	See if a key has been pressed; i.e. check if character waiting
;	on the console.  If ungetch() has been called, then
;	will return TRUE.
;
;Entry:
;	none - checks console
;
;Exit:
;	returns non-zero if key waiting
;	returns 0 if no key waiting
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_kbhit,<PUBLIC>

cBegin	<nogen>
	mov	ax,[__chbuf]
	or	ah,ah
;
; If the upper byte of [__chbuf] is non-zero, pushback buffer is empty
;
	mov	al,-1		; assume [__chbuf] is not empty
	jz	done

ifdef _DEBUGSCREEN
	cmp	__aDBswpflg,__aDBdoswp	; Aware debugger as parent?
	jne	@F			; No -- skip
	push	bx		; save register
	mov	bx,-1		; force screen swap always
	call	__aDBswpchk	; Yes -- see if we need to swap screens
	pop	bx
@@:
endif	; _DEBUGSCREEN


	mov	ah,0bh		; check keyboard status
	callos
	mov	ah,0		; answer is in al
done:
	ret
cEnd	<nogen>

sEnd
	end
