	page	,132
	title	outp - direct port output
;***
;outp.asm - write byte to output port
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines outp() - write byte to I/O port
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	.list

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _outp(port, value) - write byte value to I/O port
;
;Purpose:
;	Write the given byte to the specified I/O port
;
;Entry:
;	unsigned port - port to write to
;	int value - byte value to write to port
;
;Exit:
;	returns lower byte of value (upper byte is zeroed)
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_outp,<PUBLIC>,<>

	parmW	port
	parmW	value

cBegin
	mov	dx,port
	mov	al,byte ptr [value]
	out	dx,al
	mov	ah,0		; return only lower byte of "value"
cEnd	<nolocals>

sEnd

	end
