	page	,132
	title	putch - write a character to standard output
;***
;putch.asm - contains putch() for DOS 3 (write char to console)
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All Rights Reserved.
;
;Purpose:
;	The routine "putch()" writes a single character to standard output.
;
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
include msdos.inc
include defsegs.inc
.list


ifndef _WINDOWS
	_DEBUGSCREEN equ 1		; debug screen swapping
endif


ifdef _DEBUGSCREEN
CrtDefSegs <dbdata>

sBegin	dbdata				;
	assumes ds,data 		; Used to do the running under
externW 	__aDBswpflg		; a debugger screen swapping
externW 	__aDBswpchk		;
sEnd	dbdata				;
	extrn	__aDBdoswp:ABS		;
endif	; _DEBUGSCREEN

sBegin	code

	assumes cs,code

page
;***
;int _putch(c) - write one character to standard output (usually the console)
;
;Purpose:
;	Calls INT 21H Function 6, to output the character
;
;Entry:
;	int c - Character to be output
;
;Exit:
;	AL = character that was output, AH = 0
;
;Uses:
;	DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_putch,<PUBLIC>,<>

	parmb	byt

cBegin
	mov	dl,[byt]	; character to output
	mov	ah,6h
ifdef _DEBUGSCREEN
	cmp	__aDBswpflg,__aDBdoswp	; Aware debugger as parent?
	jne	@F			; No -- skip
	mov	bx,-1
	call	__aDBswpchk		; Yes -- see if we need to swap screens
@@:
endif	; _DEBUGSCREEN
	callos
	xchg	ax,dx		; mov  al,[byt]
	mov	ah,0
	pop	bp
	ret
cEnd	<nogen>

sEnd

	end
