	page	,132
	title	movedata - large model memcpy for all models
;***
;movedata.asm - segmented move of data
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines movedata() - large model move bytes
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	.list

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;void _movedata(srcseg, srcoff, dstseg, dstoff, nbytes) - move far data
;
;Purpose:
;	Move specified number of bytes between source and destination
;	segment:offsets.
;
;	WARNING: this routine is NOT careful of overlapping moves or
;	efficiency of data transfer (word boundaries and moving words
;	instead of bytes).
;
;Entry:
;	unsigned srcseg - source segment
;	unsigned srcoff - source offset
;	unsigned dstseg - destination segment
;	unsigned dstoff - destination offset
;	unsigned nbytes - number of bytes to move
;
;Exit:
;	None.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_movedata,<PUBLIC>,<di,si,ds>

	parmw	sorcseg
	parmw	sorcoff
	parmw	destseg
	parmw	destoff
	parmw	nbytes

cBegin
	mov	ds,sorcseg
	mov	si,sorcoff
	mov	es,destseg
	mov	di,destoff
	mov	cx,nbytes

rep	movsb

cEnd

sEnd
	end
