	page	,132
	title	segread - return segment registers
;***
;segread.asm - read the segment registers
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines segread() - read the segment registers
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	.list


; offsets in the struct

OFFES	=	0
OFFCS	=	2
OFFSS	=	4
OFFDS	=	6

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;void _segread(segregs) - read the segment registers
;
;Purpose:
;	reads the current segment registers into the structure pointed
;	to by segregs.
;
;Entry:
;	struct SREGS *segreg - structure to fill with segment register values
;
;Exit:
;	None.
;
;Uses:
;	ax, bx, dx
;
;Exceptions:
;
;*******************************************************************************

cProc	_segread,<PUBLIC>,<>

	parmdp	segregs

cBegin

if	sizeD
	mov	ax,es		; save es
	les	bx,segregs
	mov	es:[bx+OFFDS],ds
	mov	es:[bx+OFFES],ax ; (actually es)
if	sizeC
	mov	dx,[bp+4]	; get caller's cs off of stack
	mov	es:[bx+OFFCS],dx
else
	mov	es:[bx+OFFCS],cs
endif
	mov	es:[bx+OFFSS],ss
	mov	es,ax		; restore es
else
	mov	bx,segregs
	mov	[bx+OFFDS],ds
	mov	[bx+OFFES],es
if	sizeC
	mov	dx,[bp+4]	; get caller's cs off of stack
	mov	[bx+OFFCS],dx
else
	mov	[bx+OFFCS],cs
endif
	mov	[bx+OFFSS],ss
endif

cEnd

sEnd
	end
