	page	,132
	title	ungetch.asm - push back a character from getch/getche
;***
;ungetch.asm - contains ungetch()
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	The routine "ungetch()" pushes back a character to be returned
;	by the next call to either "getch()" or "getche()".   "ungetch()"
;	will return -1 to indicate an error if it is called two or more
;	times without an intervening call to "getch()" or "getche()".
;	(The push-back buffer is a word to allow it to represent the 256
;	possible byte values [0-255], plus the empty state [-1].)
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include os2dll.inc
	.list

sBegin	data
	assumes ds,data
	extrn	__chbuf:word	; Push-back buffer (-1 == empty)
sEnd



sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _ungetch(c) - push back one character for "getch()" or "getche()"
;
;Purpose:
;	If the Push-back buffer "__chbuf" is -1 Then
;	    Set "__chbuf" to the argument and return the argument
;	Else
;	    Return -1 to indicate an error
;
;Entry:
;	int c - Character to be pushed back
;
;Exit:
;	If successful
;	    AX = character that was pushed back
;	Else if error
;	    AX = -1
;
;Uses:
;	DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_ungetch,<PUBLIC>,<>

	parmW	byt

cBegin

ungetch0:			; common code
	mov	dx,-1		; -1 == EOF
	mov	ax,[__chbuf]	; see if the pushback buffer is empty
	or	ah,ah
	jz	err		; there is already a character pushed back

	mov	ax,byt
	cmp	ax,dx		; byt == EOF is not allowed
	je	done
	mov	dx,ax		; DX = byt for return value
	mov	ah,0		; byt & 0xFF
	mov	[__chbuf],ax	; unget the character
err:
	xchg	ax,dx		; AX = -1 for error, otherwise "byt"

done:
	pop	bp
	ret
cEnd	<nogen>

sEnd

	end
