/***
*atof.c - convert char string to floating point number
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   Converts a character string into a floating point number.
*
*******************************************************************************/

#include <fltintrn.h>
#include <register.h>
#include <string.h>
#include <ctype.h>


/***
*double atof(nptr) - convert string to floating point number
*
*Purpose:
*   atof recognizes an optional string of whitespace, then
*   an optional sign, then a string of digits optionally
*   containing a decimal point, then an optional e or E followed
*   by an optionally signed integer, and converts all this to
*   to a floating point number.  The first unrecognized
*   character ends the string.
*
*Entry:
*   nptr - pointer to string to convert
*
*Exit:
*   returns floating point value of character representation
*
*Exceptions:
*
*******************************************************************************/

    FLT _fltin( const char *, int, int, int );

DOUBLE  atof(nptr)
REG1 const char *nptr;
{



    /* scan past leading space/tab characters */

    while (isspace(*nptr))
        nptr++;

    /* let _fltin routine do the rest of the work */

    return( _fltin( nptr, strlen(nptr), 0, 0 )->dval );
}
