	page	,132
	title	atox	- workhorse routine for atoi, atol
;***
;atox.asm - workhorse routine for atoi and atol conversion
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Converts a character string into an int or long.  See
;	atoi.asm or atol.asm for actual entry points.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
.list

page
;***
;long _catox(nptr) - workhorse routine for atoi and atol
;
;Purpose:
;	Converts ASCII string pointed to by nptr to binary.  Actual
;	entry points for doing conversion in atoi.asm and atol.asm.
;
;Entry:
;	nptr = ptr to string to convert
;
;Exit:
;	return long int value of the string
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


sBegin	code
assumes cs,code
assumes ds,data

TAB=	9			; tab character code

cProc	<_catox>,<PUBLIC>,<>

	parmDP	nptr

cBegin
	push	di
	push	si

if	sizeD
	push	ds
	lds	si,nptr
else
	mov	si,nptr
endif
	xor	ax,ax
	cwd
	xor	bx,bx		; ax = dx = bx = 0

skipwhite:
	lodsb			; skip over spaces and tabs
	cmp	al,' '
	je	skipwhite
	cmp	al,TAB
	je	skipwhite

	push	ax		; save sign indicator
	cmp	al,'-'		; eat + or -
	je	getnextchar
	cmp	al,'+'
	jne	getnext

getnextchar:
	lodsb

getnext:			; accumulate number in dx:bx
	cmp	al,'9'
	ja	done
	sub	al,'0'
	jb	done
	shl	bx,1
	rcl	dx,1		; * 2
	mov	cx,bx
	mov	di,dx
	shl	bx,1
	rcl	dx,1		; * 4
	shl	bx,1
	rcl	dx,1		; * 8
	add	bx,cx
	adc	dx,di		; * 10
	add	bx,ax
	adc	dx,0
	jmp	getnextchar

done:
	pop	ax		; pop character into AX
	cmp	al,'-'		; check sign flag
	xchg	ax,bx		; dx:ax = number
	jnz	return

	neg	ax		; negate dx:ax
	adc	dx,0
	neg	dx

return:

if	sizeD
	pop	ds
endif
	pop	si
	pop	di


ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd	code

	end
