/***
*gcvt.c - convert floating point number to character string
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Converts floating point number into character string representation.
*
*******************************************************************************/

#include <fltintrn.h>
#include <internal.h>
#include <register.h>


/***
*double _gcvt(value, ndec, buffer) - convert floating point value to char string
*
*Purpose:
*   gcvt converts the value to a null terminated ASCII string
*   buf.  It attempts to produce ndigit significant digits
*   in Fortran F format if possible, ortherwise E format,
*   ready for printing.  Trailing zeros may be suppressed.
*   No error checking or overflow protection is provided.
*   NOTE - to avoid the possibility of generating floating
*   point instructions in this code we fool the compiler
*   about the type of the 'value' parameter using a struct.
*   This is OK since all we do is pass it off as a
*   parameter.
*
*Entry:
*   value - double - number to be converted
*   ndec - int - number of significant digits
*   buf - char * - buffer to place result
*
*Exit:
*   result is written into buffer; it will be overwritten if it has
*   not been made big enough.
*
*Exceptions:
*
*******************************************************************************/

#ifdef _WINDOWS
static double st_value;
#endif

char *  _gcvt( value, ndec, buf )
DOUBLE value;
int ndec;
char *buf;
{


    STRFLT string;
    int    magnitude;
    char   *rc;

    REG1 char *str;
    REG2 char *stop;



    /* get the magnitude of the number */

    string = _fltout( value );

    magnitude = string->decpt - 1;



    /* output the result according to the Fortran G format as outlined in
       Fortran language specification */

#ifdef _WINDOWS
    st_value = *(double *)&value;
    if ( magnitude < -1  ||  magnitude > ndec-1 )
        rc = str = _cftoe( (double __far * ) &st_value, buf, ndec-1, 0);
    else
        rc = str = _cftof( (double __far * ) &st_value, buf, ndec-string->decpt );
#else
    if ( magnitude < -1  ||  magnitude > ndec-1 )
        /* then  Ew.d  d = ndec */
        rc = str = _cftoe( (double *)&value, buf, ndec-1, 0);
    else
        /* Fw.d  where d = ndec-string->decpt */
        rc = str = _cftof( (double *)&value, buf, ndec-string->decpt );
#endif

    while (*str && *str != '.')
        str++;

    if (*str++) {
        while (*str && *str != 'e')
            str++;

        stop = str--;

        while (*str == '0')
            str--;

        while (*++str = *stop++)
            ;
    }

    return(rc);
}
