	page	,132
	title	itoa - convert binary integer to ASCII string
;***
;itoa.asm - Convert binary integer to ASCII string
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Converts integer to ASCII string.  Uses code in xtoa.asm.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
.list

page
;***
;char *_itoa(val, buf, radix) - convert binary int to ASCII string
;
;Purpose:
;	Converts an int to a character string.
;
;Entry:
;	int val - number to be converted
;	int radix - base to convert into
;	char *buf - ptr to buffer to place result
;
;Exit:
;	fills in space pointed to by buf with string result
;	returns a pointer to this buffer
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************


sBegin	code
assumes cs,code
assumes ds,data

extrn	__cxtoa:near

cProc	_itoa,<PUBLIC>,<di,si>

	parmW	ival
	parmDP	ibuf
	parmW	iradix

cBegin
	mov	bl,1		; signed conversion
	mov	cx,iradix
	mov	ax,ival
	xor	dx,dx
	cmp	cx,10		; signed?
	jne	noextend

	cwd			; dx:ax = value

noextend:

if	sizeD
	push	ds
	lds	di,ibuf
else
	mov	di,ibuf
endif

	jmp	__cxtoa

cEnd	nogen

sEnd	code

	end
