/***
*mblen.c - Convert multibyte char to wide char.
*
*   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Convert a multibyte character into the equivalent wide character.
*
*******************************************************************************/

#include <stdlib.h>
#include <ctype.h>

#ifndef MODELINDEP
unsigned short __mb_cur_max = 1;
#endif  /* MODELINDEP */


#define _WC_PADHIBYTE   0x0000

/***
*int mblen() - Convert mbc to wc
*
*Purpose:
*   Convert a multi-byte character into the equivalent wide character,
*   according to the LC_CTYPE category of the current locale.
*   [ANSI].
*
*   NOTE:  Currently, the C libraries support the "C" locale only.
*Entry:
*   const char *s = pointer to multibyte character
*   size_t      n = maximum length of multibyte character to consider
*
*Exit:
*   If s = NULL, returns 0, indicating we use (only) state-independent
*   character encodings.
*   If s != NULL, returns:   0 (if *s = null char)
*               -1 (if the next n or fewer bytes not valid mbc)
*                number of bytes comprising converted mbc
*
*Exceptions:
*
*******************************************************************************/

#ifdef MODELINDEP
int __far __cdecl  _fmblen
    (
    const char __far * s,
#else                           /* MODELINDEP */
int __cdecl  mblen
    (
    const char * s,
#endif                          /* MODELINDEP */
    size_t n
    )
{
    if (!s)
        return(0); /* Note: only support state-independent for now */
    if (n<sizeof(char))
        return(-1); /* UNDONE: handle other errors */
    if (!(*s))
        return(0);
    if (isleadbyte(*s))
        {
        /* validate high byte of mbcs char */
        return(((n<MB_CUR_MAX) || (!*(s+1))) ? -1 : MB_CUR_MAX);
        }
    else
        return(sizeof(char));
}
