/***
*mbstowcs.c - Convert multibyte char to wide char.
*
*   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Convert a multibyte char string into the equivalent wide char string.
*
*******************************************************************************/

#include <stdlib.h>


/***
*size_t mbstowcs() - Convert mbc to wc
*
*Purpose:
*   Convert a multi-byte char string into the equivalent wide char string,
*   according to the LC_CTYPE category of the current locale.
*   [ANSI].
*
*   NOTE:  Currently, the C libraries support the "C" locale only.
*Entry:
*   wchar_t *pwcs = pointer to destination wide character string buffer
*   const char *s = pointer to source multibyte character string
*   size_t      n = maximum number of wide characters to store
*
*Exit:
*   If s != NULL, returns:  (size_t)-1 (if invalid mbcs encountered)
*       Otherwise:   number of words modified (<=n), not including
*                the terminating null wide character, if any.
*
*Exceptions:
*   Returns (size_t)-1 if s is NULL or invalid mb character encountered.
*
*******************************************************************************/

#ifdef MODELINDEP
size_t __far __cdecl  _fmbstowcs
    (
    wchar_t  __far *pwcs,
    const char __far *s,
#else                           /* MODELINDEP */
size_t _cdecl  mbstowcs
    (
    wchar_t  *pwcs,
    const char *s,
#endif                          /* MODELINDEP */
    size_t n
    )

{
int retval = 0;
size_t count = 0;

#ifdef MODELINDEP
const char __far *p;
#else                           /* MODELINDEP */
const char *p;
#endif                          /* MODELINDEP */

    if (!s)
        return (size_t)-1; /* not required, but smart */
    p = s;
#ifdef MODELINDEP
    while (count<n && (retval=_fmbtowc(pwcs+count, p, MB_CUR_MAX))>0)
#else                           /* MODELINDEP */
    while (count<n && (retval=mbtowc(&pwcs[count], p, MB_CUR_MAX))>0)
#endif                          /* MODELINDEP */
        {
        p+=retval;  /* increment to point to next char */
        count++;
        }

    return((retval<0) ? (size_t)-1 : count);
}
