/***
*mbtowc.c - Convert multibyte char to wide char.
*
*   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Convert a multibyte character into the equivalent wide character.
*
*******************************************************************************/

#include <stdlib.h>



/***
*int mbtowc() - Convert mbc to wc
*
*Purpose:
*   Convert a multi-byte character into the equivalent wide character,
*   according to the LC_CTYPE category of the current locale.
*   [ANSI].
*
*   NOTE:  Currently, the C libraries support the "C" locale only.
*Entry:
*   wchar_t  *pwc = pointer to destination wide character
*   const char *s = pointer to multibyte character
*   size_t      n = maximum length of multibyte character to consider
*
*Exit:
*   If s = NULL, returns 0, indicating we only use state-independent
*   character encodings.
*   If s != NULL, returns:   0 (if *s = null char)
*               -1 (if the next n or fewer bytes not valid mbc)
*                number of bytes comprising converted mbc
*
*Exceptions:
*
*******************************************************************************/

#ifdef  MODELINDEP
int __far __cdecl  _fmbtowc
    (
    wchar_t  __far *pwc,
    const char __far *s,
#else                       /* MODELINDEP */
int __cdecl  mbtowc
    (
    wchar_t  *pwc,
    const char *s,
#endif                      /* MODELINDEP */
    size_t n
    )

{
int retval;
    if (!s)
        return 0;
#ifdef  MODELINDEP
    if (((retval=_fmblen(s,n))>=0) && (pwc))
#else                       /* MODELINDEP */
    if (((retval=mblen(s,n))>=0) && (pwc))
#endif                      /* MODELINDEP */
        {
        if (retval <= sizeof(char))
        *pwc = (wchar_t) ((unsigned char)*s);
        else
        return -1;
        }
    return retval;
}
