/***
*strtod.c - convert string to floating point number
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   Convert character string to floating point number
*
*******************************************************************************/

#include <stddef.h>
#include <fltintrn.h>
#include <string.h>
#include <ctype.h>
#include <register.h>
#include <errno.h>
#include <math.h>


/***
*double strtod(nptr, endptr) - convert string to double
*
*Purpose:
*   strtod recognizes an optional string of tabs and spaces,
*   then an optional sign, then a string of digits optionally
*   containing a decimal point, then an optional e or E followed
*   by an optionally signed integer, and converts all this to
*   to a floating point number.  The first unrecognized
*   character ends the string, and is pointed to by endptr.
*
*Entry:
*   nptr - pointer to string to convert
*
*Exit:
*   returns value of character string
*   char **endptr - if not NULL, points to character which stopped
*           the scan
*
*Exceptions:
*
*******************************************************************************/

DOUBLE  strtod( nptr, endptr )

const char *nptr;
REG2 char **endptr;
{


    FLT  answer;
    DOUBLE       tmp;
    unsigned int flags;
    REG1 char *ptr = (char *) nptr;

    /* scan past leading space/tab characters */

    while (isspace(*ptr))
        ptr++;

    /* let _fltin routine do the rest of the work */

    answer = _fltin(ptr, strlen(ptr), 0, 0);

    if ( endptr != NULL )
        *endptr = (char *) ptr + answer->nbytes;

    flags = answer->flags;
    if ( flags & (512 | 64)) {
        /* no digits found or invalid format:
           ANSI says return 0.0, and *endptr = nptr */
        tmp.x = 0.0;
        if ( endptr != NULL )
            *endptr = (char *) nptr;
    }
    else if ( flags & (128 | 1) ) {
        if ( *ptr == '-' )
            tmp.x = -HUGE_VAL;  /* negative overflow */
        else
            tmp.x = HUGE_VAL;   /* positive overflow */
        errno = ERANGE;
    }
    else if ( flags & 256 ) {
        tmp.x = 0.0;            /* underflow */
        errno = ERANGE;
    }
    else
        tmp = answer->dval;

    return(tmp);
}
