	page	,132
	title	strtol - Convert ascii string to Long integer.
;***
;strtol.asm - Contains C runtimes strtol and strtoul
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All Rights Reserved
;
;Purpose:
;	strtol - convert ascii string to long signed integer
;	strtoul - convert ascii string to long unsigned integer
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include errno.inc
	.list


assumes	cs,CODE
assumes ds,DATA

; equates for flag word
FL_UNSIGNED = 1 	; strtoul called
FL_NEG = 2		; neg sign found
FL_OVERFL = 4		; overflow
FL_READDIGIT = 8	; we've read at least one correct digit


sBegin	DATA

	externW errno

sEnd	DATA

	page

sBegin	CODE

page
;***
;strtol, strtoul(nptr,endptr,ibase) - Convert ascii string to long un/signed int.
;
;Purpose:
;	Convert an ascii string to a long 32-bit value.  The base
;	used for the caculations is supplied by the caller.  The base
;	must be in the range 0, 2-36.  If a base of 0 is supplied, the
;	ascii string must be examined to determine the base of the
;	number:
;		(a) First char = '0', second char = 'x' or 'X',
;		    use base 16.
;		(b) First char = '0', use base 8
;		(c) First char in range '1' - '9', use base 10.
;
;	If the 'endptr' value is non-NULL, then strtol/strtoul places
;	a pointer to the terminating character in this value.
;	See ANSI standard for details
;
;Entry:
;	nptr == NEAR/FAR pointer to the start of string.
;	endptr == NEAR/FAR pointer to the end of the string.
;	ibase == integer base to use for the calculations.
;
;	string format: [whitespace] [sign] [0] [x] [digits/letters]
;
;Exit:
;	Good return:
;		DX:AX == result
;
;	Overflow return:
;		strtol -- DX:AX == LONG_MAX or LONG_MIN
;		strtoul -- DX:AX == ULONG_MAX
;		strtol/strtoul -- errno == ERANGE
;
;	No digits or bad base return:
;		0
;		endptr = nptr;
;Uses:
;	AX, BX, CX, DX, SI, DI, ES
;
;Exceptions:
;	None.
;*******************************************************************************

;
; unsigned long strtoul( nptr, endptr, ibase )
;

cProc	strtoul,<PUBLIC>,<SI,DI>

	parmDP	nptr
	parmDP	endptr
	parmW	ibase
	localB	flags

cBegin
	mov	dl,FL_UNSIGNED	;remember that we entered via strtoul
	jmp	short common	;join common code
cEnd	nogen

;
; long strtol( nptr, endptr, ibase )
;

cProc	strtol,<PUBLIC>,<SI,DI>

	parmDP	nptr
	parmDP	endptr
	parmW	ibase
	localB	flags

cBegin
	xor	dl,dl		;no flags set; entered via strtol
common: mov	flags, dl	;save entry value

ifdef _LOAD_DGROUP		; if Dallas model set up ds
	push	ds
	mov	ax, DGROUP
	mov	ds, ax
endif	;_LOAD_DGROUP

if sizeD
	les	si,nptr 	;Long loads.
STRSEG	equ	<es:>
else
	mov	si,nptr
STRSEG	equ	<>
endif

whitescan:
	lods	byte ptr STRSEG [si]	; get character from string
	cmp	al,' '		; Eat white space.
	je	whitescan

	cmp	al,0Dh
	ja	endwhite
	cmp	al,9h
	jb	endwhite
	jmp	short whitescan ; eat white space (0x9-0xD)

; AL has first non-whitespace character
; See if string contains a sign character.
; Note that we must check for a sign character even if strtoul
; was our entry point -- ANSI 5-13-88 says so.
;
endwhite:
	cmp	al,'+'
	je	readsign	;Read it, then ignore it.

	cmp	al,'-'
	jne	nosign		;No sign, proceed.

	or	flags, FL_NEG	; remember the sign for later

readsign:
	lods	byte ptr STRSEG [si]	; next char in string

nosign:

; AL has first character after sign (if present)
; Now determine if user has supplied a base value or not.
;

	mov	cx,ibase
	jcxz	findbase	;No base, determine base free-lance.

	cmp	cx, 1		; base 1????
	je	badbase 	; You can't do base 1!!!!
	cmp	cx,36		; See if base in range.
	jbe	gotbase 	; Yes, skip base determination.

badbase:
	jmp	noconvert	; Bad base specified, can't convert

findbase:
	mov	cx,10		;Assume base 10 to start.
	cmp	al,'0'		;See if might be octal/hex.
	jne	gotbase 	;Base 10 alright.

	cmp	byte ptr STRSEG [si], 'x'	   ;See if hex. specifier.
	je	base16		;Yes, Use Hex. math.

	cmp	byte ptr STRSEG [si], 'X'
	je	base16		;Use Hex. math.

	; OK, a prefix 0 but no 'x' after -- must be octal

	mov	cx,8		;Use octal math.
	jmp	short gotbase

base16:
	mov	cx,16		;Setup for base 16.

gotbase:
	mov	ibase,cx	;Force set base

; Now, we might have a '0x' in front of our number, if base 16
; (user or free-lance set).  If so, we must now eat those two characters.
; octal prefixes are no problem, because leading zeros are parsed fine
; by the normal conversion routine.

	cmp	cx,16		; hexadecimal
	jne	nohexprefix	; nope, so we're OK
	cmp	al, '0' 	; leading '0'
	jne	nohexprefix	; nope, so we're OK
	cmp	byte ptr STRSEG [si], 'x'	  ; '0x'?
	je	hexprefix	; yes, take it off
	cmp	byte ptr STRSEG [si], 'X'	  ; '0X'?
	jne	nohexprefix	; nope, we're OK

hexprefix:
	; advance two characters to eat 0x prefix
	inc	si
	lods	byte ptr STRSEG [si]

nohexprefix:

;
; Zero out result registers
;

	xor	dx,dx		;DX:BX == result == ZERO.
	xor	bx,bx

; Currently AL == first ascii digit.
; DX:BX is the accumlation register pair, initialized to ZERO.
;
; Perform conversion by long multiplication.
; Note that we must keep scanning digits on overflow, according
; to ANSI 5-13-88
; FL_READDIGIT is set if we read at least one valid letter/digit
; FL_OVERFLOW is set if we have unsigned overflow
; we exit to done:

strtol5:
	call	trans		;Convert to binary digit.
	jc	done		;Non-digit/letter: All done.

	mov	cx,ibase	;get base (we'll need it for mul)
	cmp	ax,cx		;digit >= base ?
	jae	done		;All done.

	or	flags, FL_READDIGIT	; read at least one digit now
	mov	di,ax		;Save digit.
	mov	ax,dx		;hiword of current result
	mul	cx		;hiword * base
	jnc	noover1 	;carry flag means overflow
	or	flags, FL_OVERFL	; set overflow
noover1:
	push	ax		;save mul result
	mov	ax,bx		;loword of current result
	mul 	cx		;loword * base
	pop	cx		;get previous mul result
	add	dx,cx 		;dx <- hiword of new result
	jnc	noover2 	;carry flag means overflow
	or	flags, FL_OVERFL	; set overflow
noover2:
	add	ax,di		;Add in new digit.
	adc	dx,0
	jnc	noover3 	;carry flag means overflow
	or	flags, FL_OVERFL	; set overflow
noover3:
	mov	bx,ax		;Rearrange registers alittle.
	lods	byte ptr STRSEG [si]	; next char in string
	jmp	short strtol5	;Cycle for next digit.

;========================================================================

;
; Overflow occurred: check the entry code and return the correct value;
;		     set errno to ERANGE
; For strtoul, return ULONG_MAX
; For strtol, return LONG_MAX or LONG_MIN according to sign
; We know that LONG_MIN = -LONG_MAX, so we set LONG_MAX and let the exit
; routine negate it if necessary.
;

overflow:

	mov	[errno],ERANGE		; modify errno

	mov	dx,07FFFh		;assume strtol
	mov	bx,0FFFFh
	test	flags, FL_UNSIGNED	; strtol?
	jz	exit			;yes, all set
	or	dx,08000h		;no, use unsigned error code
	and	flags, NOT FL_NEG	; don't negate unsigned error code
	jmp	short exit		;join good return

;=========================================================================

; Could not convert the number, because either a bad base was specified
; or no valid digit was found.	According to ANSI, we must backup to
; the beginning of the string and return 0; errno is not set.

noconvert:
	mov	si, word ptr (nptr)	; backup to start, es already set
	xor	bx, bx
	xor	dx, dx			; return 0
	jmp	short exit		; go to exit routine

;=========================================================================

;
; Finished converting.	Check for overflow and empty string.
; If we are doing a signed conversion, then the sign
; bit better not be set. (If it is, we had a signed overflow)
;

done:
	dec	si			; point to char that stopped the scan
	test	flags, FL_READDIGIT	; did we actually read a digit?
	jz	noconvert		; nope, setup error return vals
	test	flags, FL_OVERFL	; did we overflow?
	jnz	overflow		; yes -- setup overflow error
	test	flags, FL_UNSIGNED	; strtoul?
	jnz	exit			; if so, don't check sign bit

	or	dx,dx			;if sign bit is set,
	js	overflow		; return an overflow error
					; no errors, drop through to exit:

;
; Exit at this point.  dx:bx has value to return, negate it if the
; FL_NEG flag is set.  [es:]si has pointer to store in endptr
;

exit:

if sizeD
	mov	ax,es		;ax:si has long pointer

	les	di,endptr
	mov	cx,es
	or	cx,di		;null ptr given?
	jz	nosave		;Yes, ignore final save
	mov	Word Ptr es:[di+2],ax	; save segment part of ptr
	mov	Word Ptr es:[di],si	; put pointer into *endptr
else
	mov	di,endptr
	or	di,di		;null ptr given?
	jz	nosave		;Yes, ignore final save.
	mov	Word Ptr [di],si     ; put pointer into *endptr
endif

nosave:
	mov	ax,bx		;Return in DX:AX
	test	flags, FL_NEG	;negative?
	jz	return		;No sign to worry about.

	neg	ax		;Negate dx:ax
	adc	dx,0
	neg	dx

return:

ifdef	_LOAD_DGROUP		; if Dallas model
	pop	ds
endif	;_LOAD_DGROUP

cEnd

	page

;
; Near procedure to convert the character in AL to a valid Binary digit.
;
; Returns with AX == binary digit in range 0 -> 35.
; Returns carry set for unknown characters.
;

trans	proc	near

	cmp	al,'a'		;See if in the lower case range.
	jb	trans0

	and	al,0DFh 	;Brute force to upper case or
				; converts it to another invalid character

trans0: sub	al,'0'		;Convert to binary.
	jc	trans_exit	;digit below 0: return with carry set

	cmp	al,10		;See if pure decimal.
	jc	trans1		;pure decimal, return with carry cleared

	cmp	al,'A'-'0'	;Check for special digits.
	jc	trans_exit	;below 'A': return with carry set

	sub	al,'A'-'0'-10	;Convert possible special digit.
	cmp	al,36		;See if OK digit.

				; now carry is set if OK, cleared if bad
trans1: cmc			; reverse it for proper error return

trans_exit:
	cbw			;Clear AH, if necessary.
	ret			;Carry flag used to specify failure.

trans	endp

sEnd	CODE

	end
